/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.ConversionHyperlinkHandler;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.P;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class AbstractHyperlinkWriterModel
implements ConversionHyperlinkHandler.Model {
    private static Logger log = LoggerFactory.getLogger(AbstractHyperlinkWriterModel.class);
    protected Node content = null;
    protected String target = null;
    protected boolean external = false;
    protected String anchor = null;
    protected String docLocation = null;
    protected String rId = null;
    protected String tgtFrame = null;
    protected String tooltip = null;

    public void build(AbstractWmlConversionContext conversionContext, Object node, Node content) throws TransformerException {
        Relationship relationship = null;
        RelationshipsPart rPart = null;
        P.Hyperlink pHyperlink = (P.Hyperlink)node;
        this.content = content;
        this.setAnchor(pHyperlink.getAnchor());
        this.setDocLocation(pHyperlink.getDocLocation());
        this.setRId(pHyperlink.getId());
        this.setTgtFrame(pHyperlink.getTgtFrame());
        this.setTooltip(pHyperlink.getTooltip());
        if (conversionContext.getCurrentPart() == null) {
            log.warn("set currentPart (via conversionContext)");
        } else if (this.getRId() != null && this.getRId().length() > 0) {
            rPart = conversionContext.getCurrentPart().getRelationshipsPart();
            if (rPart == null) {
                log.error("RelationshipsPart is missing!");
            } else {
                log.debug("looking for rel" + this.getRId());
                relationship = rPart.getRelationshipByID(this.getRId());
                if (relationship != null && "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(relationship.getType())) {
                    this.setTarget(relationship.getTarget());
                    this.setExternal("External".equals(relationship.getTargetMode()));
                }
            }
        }
    }

    public void build(AbstractWmlConversionContext conversionContext, FldSimpleModel fldSimpleModel, Node content) throws TransformerException {
        List<String> parameters = fldSimpleModel.getFldParameters();
        String parameter = null;
        boolean isSwitch = false;
        char switchChar = '\u0000';
        String switchParameter = null;
        this.content = content;
        for (int idx = 0; idx < parameters.size(); ++idx) {
            parameter = parameters.get(idx);
            if (parameter == null || parameter.length() <= 0) continue;
            boolean bl = isSwitch = parameter.charAt(0) == '\\' && parameter.length() == 2;
            if (isSwitch) {
                switchChar = Character.toLowerCase(parameter.charAt(1));
                switch (switchChar) {
                    case 'l': {
                        switchParameter = FormattingSwitchHelper.getSwitchValue(idx + 1, parameters);
                        if (switchParameter == null) break;
                        this.setTarget(switchParameter);
                        ++idx;
                        break;
                    }
                    case 't': {
                        switchParameter = FormattingSwitchHelper.getSwitchValue(idx + 1, parameters);
                        if (switchParameter == null) break;
                        this.setTgtFrame(switchParameter);
                        ++idx;
                        break;
                    }
                    case 'n': {
                        this.setTgtFrame("_blank");
                        break;
                    }
                    case 'o': {
                        switchParameter = FormattingSwitchHelper.getSwitchValue(idx + 1, parameters);
                        if (switchParameter == null) break;
                        this.setTooltip(switchParameter);
                        ++idx;
                        break;
                    }
                }
                continue;
            }
            if (idx != 0) continue;
            this.setTarget(FormattingSwitchHelper.getSwitchValue(idx, parameters));
        }
        if (this.getTarget() != null && this.getTarget().length() > 0 && (this.getTarget().indexOf(47) > -1 || this.getTarget().indexOf(92) > -1 || this.getTarget().indexOf(46) > -1 || this.getTarget().indexOf(58) > -1)) {
            this.setExternal(true);
        }
    }

    public String getExternalTarget() {
        return this.isExternal() ? this.getTarget() : null;
    }

    public String getInternalTarget() {
        String ret;
        String string = ret = this.isExternal() ? null : this.getTarget();
        if (ret == null) {
            ret = this.getAnchor();
        }
        if (ret == null) {
            ret = this.getDocLocation();
        }
        return ret;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getDocLocation() {
        return this.docLocation;
    }

    public void setDocLocation(String docLocation) {
        this.docLocation = docLocation;
    }

    public String getRId() {
        return this.rId;
    }

    public void setRId(String rId) {
        this.rId = rId;
    }

    public String getTgtFrame() {
        return this.tgtFrame;
    }

    public void setTgtFrame(String tgtFrame) {
        this.tgtFrame = tgtFrame;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public Node getContent() {
        return this.content;
    }

    public String toString() {
        return "HyperlinkModel [target=" + this.target + ", external=" + this.external + ", anchor=" + this.anchor + ", docLocation=" + this.docLocation + ", rId=" + this.rId + ", tgtFrame=" + this.tgtFrame + "]";
    }
}

