/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.util.HashMap;
import java.util.Map;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.ConversionHyperlinkHandler;
import org.docx4j.convert.out.common.writer.AbstractMessageWriter;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversionContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractConversionContext.class);
    public static final String CONVERSION_CONTEXT_ID = "conversionContext";
    protected static final AbstractMessageWriter DUMMY_WRITER = new AbstractMessageWriter(){

        public DocumentFragment notImplemented(AbstractConversionContext context, NodeIterator nodes, String message) {
            return null;
        }

        public DocumentFragment message(AbstractConversionContext context, String message) {
            return null;
        }

        protected String getOutputSuffix() {
            return null;
        }

        protected String getOutputPrefix() {
            return null;
        }
    };
    protected static final ConversionHyperlinkHandler DUMMY_HYPERLINK_HANDLER = new ConversionHyperlinkHandler(){

        public void handleHyperlink(ConversionHyperlinkHandler.Model hyperlinkModel, OpcPackage opcPackage, Part currentPart) throws Docx4JException {
        }
    };
    private Map<String, Object> xsltParameters = null;
    private OpcPackage opcPackage = null;
    private ConversionImageHandler imageHandler = null;
    private ConversionHyperlinkHandler hyperlinkHandler = null;
    private AbstractMessageWriter messageWriter = null;

    protected AbstractConversionContext(AbstractMessageWriter messageWriter, AbstractConversionSettings conversionSettings, OpcPackage localOpcPackage) {
        this.initializeSettings(conversionSettings, localOpcPackage);
        this.messageWriter = this.initializeMessageWriter(messageWriter);
    }

    protected void initializeSettings(AbstractConversionSettings settings, OpcPackage localOpcPackage) {
        if (settings != null) {
            if (localOpcPackage == null && settings.getWmlPackage() == null) {
                throw new IllegalArgumentException("The OpcPackage is missing in the settings.");
            }
            this.imageHandler = this.initializeImageHandler(settings, settings.getImageHandler());
            this.hyperlinkHandler = this.initializeHyperlinkHandler(settings, settings.getHyperlinkHandler());
            this.opcPackage = this.initializeOpcPackage(settings, localOpcPackage != null ? localOpcPackage : settings.getWmlPackage());
            this.xsltParameters = this.initializeXsltParameters(settings, settings.getSettings());
        }
    }

    protected ConversionImageHandler initializeImageHandler(AbstractConversionSettings settings, ConversionImageHandler handler) {
        return handler;
    }

    protected ConversionHyperlinkHandler initializeHyperlinkHandler(AbstractConversionSettings settings, ConversionHyperlinkHandler handler) {
        return handler != null ? handler : DUMMY_HYPERLINK_HANDLER;
    }

    protected OpcPackage initializeOpcPackage(AbstractConversionSettings settings, OpcPackage opcPackage) {
        return opcPackage;
    }

    protected Map<String, Object> initializeXsltParameters(AbstractConversionSettings settings, Map<String, Object> settingParameters) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (settingParameters != null) {
            ret.putAll(settingParameters);
            ret.remove("imageHandler");
            ret.remove("wmlPackage");
            ret.remove("imageIncludeUUID");
            ret.remove("imageDirPath");
        }
        ret.put(CONVERSION_CONTEXT_ID, this);
        return ret;
    }

    protected AbstractMessageWriter initializeMessageWriter(AbstractMessageWriter writer) {
        return writer != null ? writer : DUMMY_WRITER;
    }

    protected OpcPackage getOpcPackage() {
        return this.opcPackage;
    }

    public ConversionImageHandler getImageHandler() {
        return this.imageHandler;
    }

    protected ConversionHyperlinkHandler getHyperlinkHandler() {
        return this.hyperlinkHandler;
    }

    public void handleHyperlink(ConversionHyperlinkHandler.Model model) throws Docx4JException {
        this.getHyperlinkHandler().handleHyperlink(model, this.getOpcPackage(), null);
    }

    public AbstractMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    public Map<String, Object> getXsltParameters() {
        return this.xsltParameters;
    }

    public Logger getLog() {
        return log;
    }
}

