/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.DiffXAlgorithmBase;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class DiffXKumarRangan
extends DiffXAlgorithmBase {
    private static final boolean DEBUG = false;
    private int[] R1;
    private int[] R2;
    private int[] LL;
    private int[] LL1;
    private int[] LL2;
    private int R;
    private int S;
    private int iSeq2 = 0;
    private int length = -1;
    private DiffXFormatter df = null;

    public DiffXKumarRangan(EventSequence seq0, EventSequence seq1) {
        super(seq0, seq1);
    }

    public int length() {
        if (this.length < 0) {
            this.length = this.calculateLength();
        }
        return this.length;
    }

    public void process(DiffXFormatter formatter) throws IOException {
        this.length = this.calculateLength();
        this.df = formatter;
        this.generateLCS(0, this.length1 - 1, 0, this.length2 - 1, this.length1, this.length2, this.length);
    }

    private void init() {
        this.R1 = new int[this.length2 + 1];
        this.R2 = new int[this.length2 + 1];
        this.LL = new int[this.length2 + 1];
        this.LL1 = new int[this.length2 + 1];
        this.LL2 = new int[this.length2 + 1];
        this.iSeq2 = 0;
    }

    private int calculateLength() {
        this.init();
        this.R = 0;
        this.S = this.length1 + 1;
        while (this.S > this.R) {
            --this.S;
            this.fillOne(0, this.length1 - 1, 0, this.length2 - 1, this.length1, this.length2, 1);
            DiffXKumarRangan.copyUpTo(this.R2, this.R1, this.R);
        }
        return this.S;
    }

    private void fillOne(int start1, int end1, int start2, int end2, int m, int n, int sign) {
        int j = 1;
        int i = this.S;
        boolean over = false;
        this.R2[0] = n + 1;
        int lower2 = 0;
        int position2 = 0;
        int temp = 0;
        while (i > 0 & !over) {
            lower2 = j > this.R ? 0 : this.R1[j];
            for (position2 = this.R2[j - 1] - 1; position2 > lower2 && !this.sequence1.getEvent((i - 1) * sign + start1).equals(this.sequence2.getEvent((position2 - 1) * sign + start2)); --position2) {
            }
            temp = Math.max(position2, lower2);
            if (temp == 0) {
                over = true;
                continue;
            }
            this.R2[j] = temp;
            --i;
            ++j;
        }
        this.R = j - 1;
    }

    private int[] calMid(int start1, int end1, int start2, int end2, int m, int n, int sign, int waste) {
        this.LL = new int[n + 1];
        this.R = 0;
        this.S = m;
        while (this.S >= m - waste) {
            this.fillOne(start1, end1, start2, end2, m, n, sign);
            DiffXKumarRangan.copyUpTo(this.R2, this.R1, this.R);
            --this.S;
        }
        DiffXKumarRangan.copyUpTo(this.R1, this.LL, this.R);
        return this.LL;
    }

    private void generateLCS(int start1, int end1, int start2, int end2, int m, int n, int lcs) throws IOException {
        if (m - lcs < 2) {
            this.getLCSMinimumWaste(start1, end1, start2, end2, m, n, lcs);
        } else {
            this.getLCSMoreWaste(start1, end1, start2, end2, m, n, lcs);
        }
    }

    private void getLCSMinimumWaste(int start1, int end1, int start2, int end2, int m, int n, int lcs) throws IOException {
        int waste = m - lcs;
        this.LL = this.calMid(start1, end1, start2, end2, m, n, 1, waste);
        int i = 0;
        while (i < lcs && this.sequence1.getEvent(i + start1).equals(this.sequence2.getEvent(this.LL[lcs - i] - 1 + start2))) {
            this.df.format(this.sequence1.getEvent(i + start1));
            ++this.iSeq2;
            if (++i >= lcs) continue;
            this.writeDeleted(this.LL[lcs - i] - 1 + start2);
        }
        if (i < m) {
            this.df.insert(this.sequence1.getEvent(i + start1));
        }
        if (i < lcs) {
            this.writeDeleted(this.LL[lcs - i] - 1 + start2);
        }
        ++i;
        while (i < m) {
            this.df.format(this.sequence1.getEvent(i + start1));
            ++this.iSeq2;
            this.writeDeleted(this.LL[m - i] - 1 + start2);
            ++i;
        }
        this.writeDeleted(this.LL[0] - 1 + start2);
    }

    private void getLCSMoreWaste(int start1, int end1, int start2, int end2, int m, int n, int lcs) throws IOException {
        int k;
        int waste1 = (int)Math.ceil((float)(m - lcs) / 2.0f);
        this.LL1 = this.calMid(end1, start1, end2, start2, m, n, -1, waste1);
        int r1 = this.R;
        for (int j = 0; j <= r1; ++j) {
            this.LL1[j] = n + 1 - this.LL1[j];
        }
        int waste2 = (int)Math.floor((float)(m - lcs) / 2.0f);
        this.LL2 = this.calMid(start1, end1, start2, end2, m, n, 1, waste2);
        int r2 = this.R;
        for (k = Math.max(r1, r2); k > 0 && (k > r1 || lcs - k > r2 || this.LL1[k] >= this.LL2[lcs - k]); --k) {
        }
        int u = k + waste1;
        int v = this.LL1[k];
        this.generateLCS(start1, start1 + u - 1, start2, start2 + v - 1, u - 1 + 1, v - 1 + 1, u - waste1);
        this.generateLCS(start1 + u, end1, start2 + v, end2, end1 - start1 + 1 - u, end2 - start2 + 1 - v, m - u - waste2);
    }

    private void writeDeleted(int jSeq2) throws IOException {
        while (jSeq2 > this.iSeq2) {
            this.df.delete(this.sequence2.getEvent(this.iSeq2++));
        }
    }

    private void printState(int f) {
        if ((f & 1) == 1) {
            System.err.println("  R=" + this.R);
        }
        if ((f & 0x10) == 16) {
            System.err.println("  S=" + this.S);
        }
        if ((f & 0x11) > 0) {
            System.err.println();
        }
        if ((f & 0x100) == 256) {
            System.err.print(" R1={");
            for (int element : this.R1) {
                System.err.print(" " + element);
            }
            System.err.println(" }");
        }
        if ((f & 0x1000) == 4096) {
            System.err.print(" R2={");
            for (int element : this.R2) {
                System.err.print(" " + element);
            }
            System.err.println(" }");
        }
        if ((f & 0x10000) == 65536) {
            System.err.print(" LL={");
            for (int element : this.LL) {
                System.err.print(" " + element);
            }
            System.err.println(" }");
        }
        if ((f & 0x100000) == 0x100000) {
            System.err.print(" LL1={");
            for (int element : this.LL1) {
                System.err.print(" " + element);
            }
            System.err.println(" }");
        }
        if ((f & 0x1000000) == 0x1000000) {
            System.err.print(" LL2={");
            for (int element : this.LL2) {
                System.err.print(" " + element);
            }
            System.err.println(" }");
        }
    }

    private static void copyUpTo(int[] a, int[] b, int len) {
        for (int i = 0; i <= len; ++i) {
            b[i] = a[i];
        }
    }
}

