/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.text;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.lists.NumberingDefinition;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Shape;

public class ParagraphSet
extends DocComponent
implements HTML4R,
PPTX4R,
DOCX4R {
    private LinkedHashMap<Integer, Paragraph> parList;
    private static String SAMPLE_SHAPE_START = "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvSpPr><p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" /><p:cNvSpPr><a:spLocks noGrp=\"${noGrp}\" /></p:cNvSpPr><p:nvPr><p:ph idx=\"${idx}\"/></p:nvPr></p:nvSpPr><p:spPr><a:xfrm rot=\"${rot}\"><a:off x=\"${offx}\" y=\"${offy}\"/><a:ext cx=\"${cx}\" cy=\"${cy}\"/></a:xfrm></p:spPr><p:txBody><a:bodyPr /><a:lstStyle />";
    private static String SAMPLE_SHAPE_END = "</p:txBody></p:sp>";

    public ParagraphSet(ParProperties parProp) {
        this.setParProperties(parProp);
        this.parList = new LinkedHashMap();
    }

    public ParagraphSet() {
        this.parList = new LinkedHashMap();
    }

    public void addParagraph(Paragraph par) {
        this.parList.put(this.size(), par);
    }

    public int size() {
        return this.parList.size();
    }

    public Paragraph getLast() {
        return this.parList.get(this.size() - 1);
    }

    public Paragraph get(int i) {
        return this.parList.get(i);
    }

    public void setTextProperties(TextProperties tp) {
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                this.parList.get(i).setTextProperties(tp);
                ++i;
            }
        }
    }

    public String toString() {
        String out = "";
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + this.parList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        if (this.size() < 1) {
            return "";
        }
        String ls = this.getParProperties().getListStyle();
        if (ls.equals("ordered") || ls.equals("unordered")) {
            this.counters.add(this.getCSSCounterName());
            if (!this.numbDefinition.hasListPointer((int)this.list_id)) {
                this.numbDefinition.addListPointer((int)this.list_id, ls.equals("ordered"));
            }
            int pl = 0;
            pl = ls.equals("ordered") ? this.numbDefinition.getOrdered().getLevelDefintion(this.getParProperties().getLevel()).getPaddingLeft() : this.numbDefinition.getUnordered().getLevelDefintion(this.getParProperties().getLevel()).getPaddingLeft();
            this.getParProperties().setPaddingLeft(pl);
        }
        LinkedHashMap<String, String> ppr = this.getParProperties().get_html_pp();
        String out = "";
        String elt_tag_beg = "";
        String elt_tag_end = "";
        String styleStr = "";
        styleStr = " style=\"" + Format.getJSString(ppr) + "\"";
        if (this.getParProperties().getListStyle().equals("ordered") || this.getParProperties().getListStyle().equals("unordered")) {
            elt_tag_beg = "<dl class=\"" + this.getCSSClassName() + " dl_reporters\"><dt" + styleStr + ">";
            elt_tag_end = "</dt></dl>";
        } else if (this.getParProperties().getListStyle().equals("blockquote")) {
            int depth = 0;
            while (depth < this.getParProperties().getLevel()) {
                elt_tag_beg = String.valueOf(elt_tag_beg) + "<blockquote>";
                elt_tag_end = String.valueOf(elt_tag_end) + "</blockquote>";
                ++depth;
            }
        } else {
            elt_tag_beg = "<p" + styleStr + ">";
            elt_tag_end = "</p>";
        }
        int i = 0;
        while (i < this.size()) {
            this.parList.get(i).setHTMLReference(this.list_id, this.counters, this.numbDefinition);
            ++i;
        }
        if (!this.getParProperties().getListStyle().equals("blockquote")) {
            i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + elt_tag_beg + this.parList.get(i).getHTML() + elt_tag_end;
                ++i;
            }
        } else {
            out = String.valueOf(out) + elt_tag_beg;
            i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + "<p" + styleStr + ">" + this.parList.get(i).getHTML() + "</p>";
                ++i;
            }
            out = String.valueOf(out) + elt_tag_end;
        }
        return out;
    }

    private Shape get_pptx_shape() throws Exception {
        if (!this.validatePPTXComponent()) {
            throw new Exception("class ParagraphSet: elements need to be set...");
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("id_shape", String.valueOf(this.shape_id));
        mappings.put("title_shape", "Texts" + this.shape_id);
        mappings.put("idx", String.valueOf(this.unique_id));
        mappings.put("noGrp", "1");
        mappings.put("cx", "" + this.getCx());
        mappings.put("cy", "" + this.getCy());
        mappings.put("offx", "" + this.getOffx());
        mappings.put("offy", "" + this.getOffy());
        mappings.put("rot", "" + this.getRot());
        Shape o = (Shape)XmlUtils.unmarshallFromTemplate((String)(String.valueOf(SAMPLE_SHAPE_START) + "<a:p/>" + SAMPLE_SHAPE_END), mappings, (JAXBContext)Context.jcPML, Shape.class);
        return o;
    }

    public Shape get_pptx_elt() throws Exception {
        Shape o = this.get_pptx_shape();
        o.setTxBody(this.get_pptx_parset());
        return o;
    }

    public Shape get_pptx_elt(NumberingDefinition nb, int startNumbering) throws Exception {
        Shape o = this.get_pptx_shape();
        o.setTxBody(this.get_pptx_parset(nb, startNumbering));
        return o;
    }

    private CTTextBody get_pptx_with_rpr(CTTextParagraphProperties rpr) throws Exception {
        Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                CTTextParagraph temp = this.parList.get(i).getPptxTextParagraph(this.slidePart);
                temp.setPPr(rpr);
                out.add(temp);
                ++i;
            }
        }
        CTTextBody tb = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        tb.setBodyPr(pp);
        tb.setLstStyle(ls);
        tb.getP().addAll(out);
        return tb;
    }

    private CTTextBody get_pptx_no_rpr() throws Exception {
        Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                CTTextParagraph temp = this.parList.get(i).getPptxTextParagraph(this.slidePart);
                out.add(temp);
                ++i;
            }
        }
        CTTextBody tb = new CTTextBody();
        tb.setBodyPr(new CTTextBodyProperties());
        tb.setLstStyle(new CTTextListStyle());
        tb.getP().addAll(out);
        return tb;
    }

    public CTTextBody get_pptx_parset() throws Exception {
        if (this.getParProperties() == null) {
            return this.get_pptx_no_rpr();
        }
        CTTextParagraphProperties rpr = this.getParProperties().get_pptx_pp();
        return this.get_pptx_with_rpr(rpr);
    }

    public CTTextBody get_pptx_parset(NumberingDefinition nb, int startNumbering) throws Exception {
        if (this.getParProperties() == null) {
            return this.get_pptx_no_rpr();
        }
        CTTextParagraphProperties rpr = this.getParProperties().get_pptx_pp(nb, startNumbering);
        return this.get_pptx_with_rpr(rpr);
    }

    @Override
    public boolean validateDOCXComponent() {
        if (this.getPPr() == null) {
            return false;
        }
        return this.ordered_num_id >= 1L;
    }

    @Override
    public Vector<P> get_docx_elt() throws Exception {
        Vector<P> out = new Vector<P>();
        if (!this.validateDOCXComponent()) {
            throw new Exception("class ParagraphSet: elements need to be set...");
        }
        PPr rpr = this.getPPr();
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                this.parList.get(i).setNumberingDefinitionsPart(this.ndp);
                this.parList.get(i).setOrderedNumID(this.ordered_num_id);
                this.parList.get(i).setUnorderedNumID(this.unordered_num_id);
                this.parList.get(i).setDOCXMLPackage(this.getDOCXMLPackage());
                P temp = this.parList.get(i).getDocxParagraph();
                temp.setPPr(rpr);
                if (i == 1) {
                    this.addBookmark(temp);
                }
                out.add(temp);
                ++i;
            }
        }
        return out;
    }

    private String getCSSSuffix() {
        return String.valueOf(this.list_id) + "-" + this.getParProperties().getLevel();
    }

    private String getCSSClassName() {
        if (this.getParProperties().getListStyle().equals("ordered")) {
            return "ol-" + this.getCSSSuffix();
        }
        if (this.getParProperties().getListStyle().equals("unordered")) {
            return "ul-" + this.getCSSSuffix();
        }
        return "";
    }

    public String getCSSCounterName() {
        return "counter-" + this.getCSSSuffix();
    }

    @Override
    public String getCSS() {
        return null;
    }

    @Override
    public String getJS() {
        return null;
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

