/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import java.util.LinkedHashMap;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.HTML4R;

public class Iframe
implements HTML4R {
    private int height;
    private int width;
    private boolean seamless;
    private String src;
    private ParProperties parProperties;

    public Iframe(int w, int h, boolean seamless, String src, ParProperties pp) {
        this.height = h;
        this.width = w;
        this.seamless = seamless;
        this.src = src;
        this.parProperties = pp;
    }

    @Override
    public String getHTML() {
        String out = "";
        LinkedHashMap<String, String> ppr = this.parProperties.get_html_pp();
        String pStart = "<p style=\"" + Format.getJSString(ppr) + "\">";
        String pStop = "</p>";
        out = String.valueOf(out) + pStart + "<iframe src=\"" + this.src + "\" width=\"" + this.width + "\" height=\"" + this.height + "\" ";
        if (this.seamless) {
            out = String.valueOf(out) + "seamless";
        }
        out = String.valueOf(out) + "></iframe>" + pStop;
        return out;
    }

    @Override
    public String getCSS() {
        return null;
    }

    @Override
    public String getJS() {
        return null;
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

