/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.pptx4r.elements.template;

import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTransform2D;
import org.lysis.reporters.tools.Debug;
import org.pptx4j.pml.Shape;

public class ShapeDescription {

	private long idx;
	private CTTransform2D xfrm = null;
	private String shapeType = null;
	private boolean islist = false;
	private CTTextListStyle listStyle;

	public ShapeDescription( Shape s ){
		shapeType = "undefined";

        try{
        	shapeType = s.getNvSpPr().getNvPr().getPh().getType().value();
        } catch( java.lang.NullPointerException e) {}
        
        try{
        	listStyle = s.getTxBody().getLstStyle();
        	islist = true;
        } catch( java.lang.NullPointerException e) {}
        
        try{
        	idx = s.getNvSpPr().getNvPr().getPh().getIdx();
        } catch( java.lang.NullPointerException e) {}
        try{
			xfrm = s.getSpPr().getXfrm();
		} catch( Exception e){}
	}
	
	public void setIdx(long _idx) {
		idx=_idx;
	}
	
	
	public boolean isList(){
		return islist;
	}
	public CTTextListStyle getListStyle(){
		return listStyle;
	}
	
	public long getIdx() {
		return idx;
	}

	public boolean hasXfrm(){
		return xfrm != null;
	}
	public CTTransform2D getXfrm() throws NullPointerException{
		if( Debug.doc_explorer ) System.err.println("shape description - getXfrm => rotate: " + xfrm.getRot());
		if( xfrm == null ) throw new NullPointerException("No Xfrm defined");
		return xfrm;
	}
	
	public int[] getDimensions(){
		int[] data = new int[4];

		Long offx = new Long(xfrm.getOff().getX());
		Long offy = new Long(xfrm.getOff().getY());
		Long extx = new Long(xfrm.getExt().getCx());
		Long exty = new Long(xfrm.getExt().getCy());
		data[0] = offx.intValue();
		data[1] = offy.intValue();
		data[2] = extx.intValue();
		data[3] = exty.intValue();
		return data;
	}
	
	public void setXfrm(CTTransform2D _xfrm){
		if( Debug.doc_explorer ) System.err.println("shape description - setXfrm => rotate arg: " + _xfrm.getRot());
		xfrm =_xfrm;
	}

	public String getShapeType(){
		return shapeType;
	}

	
	public boolean isContent(){
		return getShapeType().equals("body") 
				|| getShapeType().equals("obj") 
				|| getShapeType().equals("title") 
				|| getShapeType().equals("pic")
				|| getShapeType().equals("tbl")
				|| getShapeType().equals("subTitle")
				|| getShapeType().equals("dt")
				|| getShapeType().equals("sldNum")
				|| getShapeType().equals("ftr")
				;
	}

	public String toString(){ 
		return("type=" + shapeType + "\t{offx:" + xfrm.getOff().getX() + ",offy:" + xfrm.getOff().getY() + ",extx:" + xfrm.getExt().getCx() + ",exty:" + xfrm.getExt().getCy() + "}");
	}
}
