/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import java.util.LinkedHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.lysis.reporters.html4r.elements.HTML4R;

public class MenuBar
implements Cloneable,
HTML4R {
    private LinkedHashMap<String, String> titles = new LinkedHashMap();
    private String brand;
    private String activeTitle;

    public MenuBar(String headStr) {
        this.brand = StringEscapeUtils.escapeHtml((String)headStr);
    }

    public void addTitle(String title, String filename) {
        this.titles.put(title, filename);
    }

    public void setActiveTitle(String title) {
        this.activeTitle = title;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
        }
        return o;
    }

    @Override
    public String getHTML() {
        String ul = "<ul class=\"nav navbar-nav navbar-left\">";
        for (String title : this.titles.keySet()) {
            String link = this.titles.get(title);
            ul = this.activeTitle.equals(title) ? String.valueOf(ul) + "<li class=\"active\"><a href=\"" + link + "\">" + StringEscapeUtils.escapeHtml((String)title) + "</a></li>" : String.valueOf(ul) + "<li><a href=\"" + link + "\">" + StringEscapeUtils.escapeHtml((String)title) + "</a></li>";
        }
        ul = String.valueOf(ul) + "</ul>";
        String temp = "<div class=\"bs-docs-nav\"><div class=\"navbar navbar-inverse navbar-fixed-top\" role=\"navigation\"><div class=\"container\"><a class=\"navbar-brand\" href=\"#\">" + this.brand + "</a>" + "<button class = \"navbar-toggle\" data-toggle = \"collapse\">" + "<span class = \"icon-bar\"></span>" + "<span class = \"icon-bar\"></span>" + "<span class = \"icon-bar\"></span>" + "</button>" + "<div class=\"collapse navbar-collapse\">" + ul + "</div>" + "</div>" + "</div>" + "</div>" + "<div class=\"bs-footer\" role=\"contentinfo\">" + "<div class=\"container\"></div>" + "</div>";
        return temp;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

