% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCoverage.R
\name{plotCoverage}
\alias{plotCoverage}
\title{A function to scatterplot 'score' column of a BED dataframe
plotCoverage function plots values in the ‘score’ column of the supplied bed dataframe as a function of
chromosome coordinates. The genome wide median is plotted as a pink line.}
\usage{
plotCoverage(bed, region = FALSE, plotting = TRUE)
}
\arguments{
\item{bed}{A dataframe containing 'score','chrom','chromStart' and 'chromEnd' columns (dataframe).}

\item{region}{Only plot for the provided region in the format 'chrI:1000-3000' (string, optional).}

\item{plotting}{Should the plot object be sent to the default device? (boolean, defaults to TRUE).}
}
\description{
A function to scatterplot 'score' column of a BED dataframe
plotCoverage function plots values in the ‘score’ column of the supplied bed dataframe as a function of
chromosome coordinates. The genome wide median is plotted as a pink line.
}
\examples{
plotCoverage(W303_G2)
plotObject <- plotCoverage(W303_S,plotting=FALSE)
}
\keyword{BED}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{scatterplot}
