% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerSignificanceInterim.R
\name{powerSignificanceInterim}
\alias{powerSignificanceInterim}
\title{Interim power of a replication study}
\usage{
powerSignificanceInterim(
  zo,
  zi,
  c = 1,
  f = 1/2,
  level = 0.025,
  designPrior = c("conditional", "informed predictive", "predictive"),
  analysisPrior = c("flat", "original"),
  alternative = c("one.sided", "two.sided"),
  shrinkage = 0
)
}
\arguments{
\item{zo}{Numeric vector of z-values from original studies.}

\item{zi}{Numeric vector of z-values from interim analyses of replication studies.}

\item{c}{Ratio of the sample size of the replication study to the sample size of the original study.
Default is 1.}

\item{f}{Fraction of the replication study already completed. Default is 0.5.}

\item{level}{Significance level. Default is 0.025.}

\item{designPrior}{Either "conditional" (default), "informed predictive", or "predictive".
"informed predictive" refers to an informative normal prior coming from the original study.
"predictive" refers to a flat prior.}

\item{analysisPrior}{Either "flat" (default) or "original".}

\item{alternative}{Either "one.sided" (default) or "two.sided".
Specifies if the significance level is one-sided or two-sided.}

\item{shrinkage}{Numeric vector with values in [0,1). Defaults to 0.
Specifies the shrinkage of the original effect estimate towards zero, e.g.,
the effect is shrunken by a factor of 25\% for \code{shrinkage=0.25}.}
}
\value{
The probability of statistical significance in the specified direction 
at the end of the replication study given the data collected so far 
in the replication study.
}
\description{
Computes the power of a replication study taking into account data from an interim analysis.
}
\details{
This is an extension of \code{powerSignificance()} and adapts the `interim power'
from section 6.6.3 of Spiegelhalter et al. (2004) to the setting of replication studies.

\code{powerSignificanceInterim} is the vectorized version of 
 \code{.powerSignificanceInterim_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
powerSignificanceInterim(zo = 2, zi = 2, c = 1, f = 1/2,
                         designPrior = "conditional",
                         analysisPrior = "flat")

powerSignificanceInterim(zo = 2, zi = 2, c = 1, f = 1/2,
                         designPrior = "informed predictive",
                         analysisPrior = "flat")

powerSignificanceInterim(zo = 2, zi = 2, c = 1, f = 1/2,
                         designPrior = "predictive",
                         analysisPrior = "flat")

powerSignificanceInterim(zo = 2, zi = -2, c = 1, f = 1/2,
                         designPrior = "conditional",
                         analysisPrior = "flat")

powerSignificanceInterim(zo = 2, zi = 2, c = 1, f = 1/2,
                         designPrior = "conditional",
                         analysisPrior = "flat",
                         shrinkage = 0.25)
}
\references{
Spiegelhalter, D. J., Abrams, K. R., and Myles, J. P. (2004).
Bayesian Approaches to Clinical Trials and Health-Care
Evaluation, volume 13. John Wiley & Sons

Micheloud, C., Held, L. (2021). Power Calculations for Replication Studies.
\url{https://arxiv.org/abs/2004.10814}
}
\seealso{
\code{\link{sampleSizeSignificance}}, \code{\link{powerSignificance}}
}
\author{
Charlotte Micheloud
}
