% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duane_plot.R
\name{duane_plot}
\alias{duane_plot}
\title{Plotting Function for Duane Analysis.}
\usage{
duane_plot(
  times,
  failures,
  point_col = "black",
  line_col = "black",
  xlab = "Cumulative Time",
  ylab = "Cumulative MTBF",
  main = "Duane Plot with Cumulative MTBF"
)
}
\arguments{
\item{times}{A vector of cumulative times at which failures occurred.}

\item{failures}{A vector of the number of failures at each corresponding time in times.}

\item{point_col}{Color for the data points (default: "black").}

\item{line_col}{Color for the fitted line (default: "black").}

\item{xlab}{Label for the x-axis (default: "Cumulative Time").}

\item{ylab}{Label for the y-axis (default: "Cumulative MTBF").}

\item{main}{Title for the plot (default: "Duane Plot with Cumulative MTBF").}
}
\value{
The function returns a list of the fitted linear model, Cumulative Time, Cumulative MTBF.
}
\description{
Plotting Function for Duane Analysis.
}
\examples{
library(ReliaGrowR)
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
fit <- duane_plot(times, failures)
summary(fit)
}
