% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SZMW.R
\name{SZMW}
\alias{SZMW}
\title{The Sarhan and Zaindin's Modified Weibull family}
\usage{
SZMW(mu.link = "log", sigma.link = "log", nu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a SZMW distribution in the \code{gamlss()} function.
}
\description{
The Sarhan and Zaindin's Modified Weibull distribution
}
\details{
The Sarhan and Zaindin's Modified Weibull distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)=(\mu + \sigma \nu x^(\nu - 1)) \exp(- \mu x - \sigma x^\nu),}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{\nu > 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu
y <- rSZMW(n=100, mu = 1, sigma = 1, nu = 1.5)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, family='SZMW',
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))

# Example 2
# Generating random values under some model
n     <- 200
x1    <- runif(n)
x2    <- runif(n)
mu    <- exp(-1.6 * x1)
sigma <- exp(0.9 - 1 * x2)
nu    <- 1.5
x     <- rSZMW(n=n, mu, sigma, nu)

mod <- gamlss(x~x1, mu.fo=~x1, sigma.fo=~x2, nu.fo=~1, family=SZMW,
              control=gamlss.control(n.cyc=50000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
coef(mod, what='nu')
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{sarhan2009modified}{RelDists}
}
\seealso{
\link{dSZMW}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
