% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foster.test.R
\name{foster.test}
\alias{foster.test}
\title{Foster-Stuart, Diersen-Trenkler or t Tests for Randomness}
\usage{
foster.test(
  XM_T,
  statistic = c("D", "d", "TM"),
  distribution = c("normal", "t"),
  weights = function(t) 1,
  trend = c("positive", "negative")
)
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{statistic}{A character string indicating the type of statistic to be 
calculated, i.e., \code{"D"} (for \eqn{DM}, \eqn{DM^\omega} or 
\eqn{DM^\omega_S}), \code{"d"} (for \eqn{dM}, \eqn{dM^\omega} or 
\eqn{dM^\omega_S}) and \code{"TM"} (for \eqn{TM}, \eqn{TM^\omega} or 
\eqn{TM^\omega_S}).}

\item{distribution}{A character string indicating the asymptotic 
distribution of the statistic, Normal distribution "normal" or 
Student's t-distribution "t".}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{trend}{A character string indicating the type of alternative 
hypothesis, positive trend in location \code{"positive"} or
negative trend in location \code{"negative"}.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the test statistic.}
  \item{parameter}{Only if \code{distribution = 't'}, degrees of freedom of 
    \eqn{t} statistic equal to \eqn{M-1}.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs Foster-Stuart, Diersen-Trenkler 
  or t record tests for trend in location based on their normal 
  or t asymptotic distribution, respectively.
  The null hypothesis of randomness is tested against the 
  alternative hypothesis.
}
\details{
In this function, the tests are implemented as given by Foster and Stuart
  (1954), Diersen and Trenkler (1996, 2001) and some modifications
  standardizing the previous statistics. Let \eqn{(I_{t,m})} be the record 
  indicator random variables of the mth series. The number of records up to
  time \eqn{T} of the mth series, \eqn{N_{T,m} = \sum_{t=2}^{T} I_{t,m}}, 
  or the weighted number of records up to time \eqn{T} of the mth series,
  \eqn{N_{T,m}^\omega = \sum_{t=2}^{T} \omega_t I_{t,m}}; for the upper and
  lower records and for the forward and backward series of the
  \eqn{(X_{t,1}),\ldots,(X_{t,M})}, \eqn{t=1,\ldots,T}, series are used for
  the statistics:
  
  If \code{statistic == "d", distribution = "normal"}, 
  \deqn{dM^\omega = \sum_{m=1}^{M} \sum_{t=2}^{T} \omega_t\,\Big( I_{t,m} - I_{t,m}^L\Big).}

  If \code{statistic == "D", distribution = "normal"}, 
  \deqn{DM^\omega = \sum_{m=1}^{M} \sum_{t=2}^{T} \Big( I_{t,m} - I_{t,m}^L - I_{t,m}^{rev} + I_{t,m}^{L,rev}\Big).}

  If \code{statistic == "TM", distribution = "normal"}, 
  \deqn{TM^\omega = \sum_{m=1}^{M} \sum_{t=1}^{T} \Big( I_{t,m} + I_{t,m}^{L,rev}\Big).}
 
  While their means are very simple to calculate, their variances become 
  unwieldly expressions and are given by Diersen and Trenkler (2001). 
  
  The p-value is calculated with the Normal asymptotic distribution in the 
  usual way with a one-sided alternative based on the \code{trend} value.
  
  If \code{distribution = "t"}, for the above statistics it is calculated a
  new one, e.g. for \eqn{DM^\omega},
  \deqn{DM_S^\omega = \frac{DM^\omega - E(DM^\omega)}{\sqrt{\widehat{Var}(DM^\omega)}},}
  where \eqn{E(DM^\omega)} is the expectation under the null, and 
  \eqn{\widehat{Var}(DM^\omega)} is an estimation of the variance obtained 
  from the sample, which is why \eqn{M>1} is required. The statistic above
  is asymptotically t distributed and it has been proved that 
  \eqn{DM_S^\omega} is highly robust against serial correlation.
}
\examples{
foster.test(ZaragozaSeries)
foster.test(ZaragozaSeries, statistic = 'd')
foster.test(ZaragozaSeries, weights = function(t) t-1)
foster.test(ZaragozaSeries, distribution = 't')
foster.test(ZaragozaSeries, distribution = 't', weights = function(t) t-1)

}
\references{
Diersen J, Trenkler G (1996). Records Tests for Trend in Location.
\emph{Statistics}, \strong{28}(1), 1-12.
doi: \href{https://doi.org/10.1080/02331889708802543}{10.1080/02331889708802543}

Diersen J, Trenkler G (2001). 
\emph{Weighted record tests for splitted series of observations}. 
En J Kunert, G Trenkler (Eds.), 
Mathematical Statistics with Applications in Biometry. 
Festschrift in Honour of Prof. Dr. Siegfried Schach (pp. 163-178). 
Lohmar: Josef Eul Verlang. 

Foster FG, Stuart A (1954). 
Distribution-Free Tests in Time-Series Based on the Breaking of Records.
\emph{Journal of the Royal Statistical Society. Series B (Methodological)}, 
\strong{16}(1), 1-22.
}
\seealso{
\code{\link{foster.plot}}
}
\author{
Jorge Castillo-Mateo
}
