% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.dfunc.r
\name{print.dfunc}
\alias{print.dfunc}
\title{Print a distance function object}
\usage{
\method{print}{dfunc}(x, ...)
}
\arguments{
\item{x}{An estimated distance function resulting from a call to \code{dfuncEstim}.}

\item{\dots}{Included for compatibility with other print methods.  Ignored here.}
}
\value{
The input distance function (\code{x}) is returned invisibly.
}
\description{
Print method for distance functions produced by \code{dfuncEstim},
which are of class \code{dfunc}.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)

# Fit half-normal detection function
dfunc <- dfuncEstim(formula=dist~1,
                    detectionData=sparrowDetectionData)

dfunc

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{plot.dfunc}}, 
\code{\link{print.abund}}, \code{\link{summary.dfunc}}
}
\keyword{models}
