% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_linear_PCA.R
\name{do.pca}
\alias{do.pca}
\title{Principal Component Analysis}
\usage{
do.pca(X, ndim = 2, cor = FALSE)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{cor}{mode of eigendecomposition. \code{FALSE} for decomposing covariance matrix,
and \code{TRUE} for correlation matrix.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{vars}{a vector containing variances of projected data onto principal components.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\code{do.pca} performs a classical principal component analysis (PCA) using
\code{RcppArmadillo} package for faster and efficient computation.
}
\examples{
\donttest{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## try covariance & correlation decomposition
out1 <- do.pca(X, ndim=2, cor=FALSE)
out2 <- do.pca(X, ndim=2, cor=TRUE)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, col=lab, pch=19, main="correlation decomposition")
plot(out2$Y, col=lab, pch=19, main="covariance decomposition")
par(opar)
}

}
\references{
\insertRef{pearson_liii_1901}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
