% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LSLS.R
\name{do.lsls}
\alias{do.lsls}
\title{Locality Sensitive Laplacian Score}
\usage{
do.lsls(
  X,
  label,
  ndim = 2,
  alpha = 0.5,
  k = 5,
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{alpha}{a weight factor; should be a real number in \eqn{[0,1]}.}

\item{k}{an integer; the size of a neighborhood.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locality Sensitive Laplacian Score (LSLS) is a supervised linear feature extraction method that combines
a feature selection framework of laplacian score where the graph laplacian is adjusted as in the
scheme of LSDA. The adjustment is taken via decomposed affinity matrices which are separately constructed
using the provided class label information.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
set.seed(100)
subid    = sample(1:150,50)
iris.dat = as.matrix(iris[subid,1:4])
iris.lab = as.factor(iris[subid,5])

## compare different neighborhood sizes
out1 = do.lsls(iris.dat, iris.lab, k=3)
out2 = do.lsls(iris.dat, iris.lab, k=6)
out3 = do.lsls(iris.dat, iris.lab, k=9)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=iris.lab, pch=19, main="LSLS::k=3")
plot(out2$Y, col=iris.lab, pch=19, main="LSLS::k=6")
plot(out3$Y, col=iris.lab, pch=19, main="LSLS::k=9")
par(opar)
}

}
\references{
\insertRef{liao_gene_2014a}{Rdimtools}
}
\seealso{
\code{\link{do.lsda}}, \code{\link{do.lscore}}
}
\author{
Kisung You
}
\concept{linear_methods}
