% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MVP.R
\name{do.mvp}
\alias{do.mvp}
\title{Maximum Variance Projection}
\usage{
do.mvp(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Maximum Variance Projection (MVP) is a supervised method based on linear discriminant analysis (LDA).
In addition to classical LDA, it further aims at preserving local information by capturing
the local geometry of the manifold via the following proximity coding,
\deqn{S_{ij} = 1\quad\textrm{if}\quad C_i \ne C_j\quad\textrm{and} = 0 \quad\textrm{otherwise}},
where \eqn{C_i} is the label of an \eqn{i}-th data point.
}
\examples{
\donttest{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

## perform MVP with different preprocessings
out1 = do.mvp(X, label)
out2 = do.mvp(X, label, preprocess="decorrelate")
out3 = do.mvp(X, label, preprocess="whiten")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="centering")
plot(out2$Y, col=label, main="decorrelating")
plot(out3$Y, col=label, main="whitening")
par(opar)
}

}
\references{
\insertRef{zhang_maximum_2007}{Rdimtools}
}
\author{
Kisung You
}
