% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LPCA.R
\name{do.lpca}
\alias{do.lpca}
\title{Locally Principal Component Analysis}
\usage{
do.lpca(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locally Principal Component Analysis (LPCA) is an unsupervised linear dimension reduction method.
It focuses on the information brought by local neighborhood structure and seeks the corresponding
structure, which may contain useful information for revealing discriminative information of the data.
}
\examples{
\donttest{
## generate default dataset
X <- aux.gensamples()

## try different neighborhood size
out1 <- do.lpca(X, ndim=2, type=c("proportion",0.01))
out2 <- do.lpca(X, ndim=2, type=c("proportion",0.1))
out3 <- do.lpca(X, ndim=2, type=c("proportion",0.25))

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="LPCA::1\% connected")
plot(out2$Y, main="LPCA::10\% connected")
plot(out3$Y, main="LPCA::25\% connected")
par(opar)
}

}
\references{
\insertRef{yang_locally_2006}{Rdimtools}
}
\author{
Kisung You
}
