% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun-toRd.R
\name{toRd}
\alias{toRd}
\alias{toRd.NULL}
\alias{toRd.list}
\alias{toRd.Rd_string}
\alias{toRd.Rd_tag}
\alias{toRd.Rd}
\alias{toRd.person}
\alias{toRd.name}
\title{Convert an object to Rd}
\usage{
toRd(obj, ...)

\\S3method{toRd}{NULL}(obj, ...)

\\S3method{toRd}{list}(obj, ..., unnest=NA)

\\S3method{toRd}{Rd_string}(obj, ...)

\\S3method{toRd}{Rd_tag}(obj, ...)

\\S3method{toRd}{Rd}(obj, ...)

\\S3method{toRd}{person}(obj, ..., include = c('given', 'family', 'email'))

\\S3method{toRd}{name}(obj, ...)
}
\arguments{
\item{obj}{object to convert}

\item{...}{passed on to methods}

\item{unnest}{Should the results be \link[base:unlist]{unlist}ed to remove nesting?
A value of FALSE indicates that nesting should never be removed,
TRUE implies always remove nested elements with class \link{Rd},
and when NA, the default, nesting will be removed
only if all elements are Rd.}

\item{include}{The parts of the person object to include.}
}
\description{
This provides the generic for converting objects to Rd.
It extends the core function \code{\link[tools:toRd]{toRd}}.
}
\examples{
str(toRd(NULL))
toRd(person('John' , 'Doe', email="john@email.com"))
toRd(c( person('John' , 'Doe', email="john@email.com")
      , person('Jane' , 'Poe', email="jane@email.com")
      ))
}
