% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent.R
\name{Rd_clean_indent}
\alias{Rd_clean_indent}
\title{Check and clean an indent string}
\usage{
Rd_clean_indent(indent.with, type = get_Rd_tag(indent.with))
}
\arguments{
\item{indent.with}{The string to use for indentation.}

\item{type}{The type of string the indent is to be.}
}
\value{
An \link{Rd_string}, of type 'TEXT' or 'CODE', see details,
wrapped in an \link{Rd} container.
}
\description{
Check and clean an indent string
}
\details{
Indents must have the following characteristics:
\itemize{
\item They must be all whitespace, i.e. spaces.
\item Newlines are not allowed.
\item Tabs, are allowed with a warning as
they violate the guidelines.
\item May only be Rd_strings of tag type \code{TEXT} or \code{RCODE}.
Code type should only be used to indent other text.
}
}
\note{
When put in \link[=Rd_canonize]{canonical} form the indents element
will often be merged with other elements.
}
\seealso{
\url{https://developer.r-project.org/Rds.html}
}
