% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movSum}
\alias{movSum}
\alias{movSumr}
\title{Weighted Simple Moving Sum}
\usage{
movSum(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE,
  align = "left")

movSumr(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{n}{An integer: moving window size, with 1 as default}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{w}{An optional weight vector of length \emph{n}.}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns a vector whose length is the same as that of \emph{vec} or is 
\code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
length of \eqn{vec}.
}
\description{
This function returns a simple moving sum of the given vector. The weight 
argument is optional.
}
\details{
This function can obtain the moving sum efficiently. It serves as somehow a generalized  
version of \code{\link{movMean}}. The difference is that it will not automatically 
normalized the weights vector, \emph{w} argument. \cr
If there is no missing value in \emph{vec}, and \emph{w} is normalized, which means
the sum of all elements is \emph{1}, this function will return a moving average.
}
\section{Functions}{
\itemize{
\item \code{movSumr}: An function equivalent to \code{movMean(..., align = "right")}
}}

\examples{
movSum(c(1, 4, 3, NA, 8), 3, align = "right", na_rm = TRUE)
movSum(c(1, 4, 3, NA, 8), 3, w = c(0.5, 0.2, 0.3), na_rm = TRUE, align = "right")
movSum(c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "right")
}
