% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movQtUE}
\alias{movQtUE}
\alias{movQtUEr}
\title{Moving quantile_UE(Moving Median, Moving Minimum, Moving Maximum)
for Unevenly Spaced Time Series}
\usage{
movQtUE(vec, pos, n = 1L, prob = 0.5, ss = 1L, na_rm = FALSE,
  sizeD = FALSE, align = "left")

movQtUEr(vec, pos, n = 1L, prob = 0.5, ss = 1L, na_rm = FALSE,
  sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{pos}{A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
N.B. We use integers to represent the (relative) positions of every point.}

\item{n}{An integer: moving window size, with 1 as default}

\item{prob}{A number: between \emph{0} and \emph{1}, meaning \emph{prob} quantile_UE}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
(when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
original vector, and the third column the moving average.
}
\description{
This function returns A matrix: the first column is the position, the second column 
the input vector, and third column moving quantile_UE of the given vector.
}
\details{
This function is especially designed for Unevenly Spaced Time Series. It is efficient as it inherits the 
similar routine of \code{movQt}. \cr
The result is kind of tricky. To make it clear, it is written to return a MATRIX. For instance, the 
third column of the output of second example is \eqn{2.5, NA, NA, NA, NA, NA, 3.0, NA, NA}. 
2.5 is the median of 1 and 4, and 4.0 the average of 4. The third column of the output of 
third example is the every third element starting from \eqn{n}th number. \cr
For how weights, \eqn{w}, work, one can refer to \code{movQt}.
}
\section{Functions}{
\itemize{
\item \code{movQtUEr}: An function equivalent to \code{movQtUE(..., align = "right")}
}}

\examples{
movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE)
movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, sizeD = TRUE)
movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE, align = "middle")
movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, sizeD = TRUE,
 align = "right")
}
