% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movMean}
\alias{movMean}
\alias{movMeanr}
\title{Weighted Simple Moving Mean}
\usage{
movMean(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE,
  align = "left")

movMeanr(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{n}{An integer: moving window size, with 1 as default}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{w}{An optional weight vector of length \emph{n}. It will be automatically normalized
(sum to 1).}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns a vector whose length is the same as that of \emph{vec} or is 
\code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
length of \eqn{vec}.
}
\description{
This function returns a simple moving average of the given vector. The weight 
argument is optional.
}
\details{
Despite of Efficient computation, usually 5~6 times faster than the moving average function in 
package 'RcppRoll', it is able to handle potential missing values
(\emph{NA} or \emph{NaN}) in the \emph{vec}. \cr
For instance, the output of the second example is \eqn{NA, NA, 2.200000 3.714286 4.875000}. The 
last number \eqn{5.5} is obtained by using re-normalized weight, namely omitting \eqn{0.2}.
The weight applied would be \eqn{0.5/(0.5+0.3)} and \eqn{0.3/(0.5+0.3)}. Hence, 
\deqn{4.875 = 3 * 0.5/(0.5+0.3) + 8 * 0.3/(0.5+0.3)}
}
\section{Functions}{
\itemize{
\item \code{movMeanr}: An function equivalent to \code{movMean(..., align = "right")}
}}

\examples{
movMean(c(1, 4, 3, NA, 8), 3, align = "right", na_rm = TRUE)
movMean(c(1, 4, 3, NA, 8), 3, w = c(0.5, 0.2, 0.3), na_rm = TRUE, align = "right")
movMean(c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "right")
}
