% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_dyn_R.R
\name{solve_interval_partition_R}
\alias{solve_interval_partition_R}
\title{solve_interval_partition (R version)}
\usage{
solve_interval_partition_R(x, kmax)
}
\arguments{
\item{x}{NumericMatix, for j>=i x(i,j) is the cost of partition element [i,...,j] (inclusive).}

\item{kmax}{int, maximum number of steps in solution.}
}
\value{
dynamic program solution.
}
\description{
Solve a for a minimal cost partition of the integers [1,...,nrow(x)] problem where for j>=i x(i,j).
is the cost of choosing the partition element [i,...,j]. 
Returned solution is an ordered vector v of length k where: v[1]==1, v[k]==nrow(x)+1, and the 
partition is of the form [v[i], v[i+1]) (intervals open on the right).
}
\examples{

x <- matrix(c(1,1,5,1,1,0,5,0,1), nrow=3)
k <- 3
solve_interval_partition_R(x, k)
solve_interval_partition(x, k)

}
\keyword{internal}
