% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_for_partition.R
\name{solve_for_partition}
\alias{solve_for_partition}
\title{Solve for a piecewise linear partiton.}
\usage{
solve_for_partition(x, y, ..., w = NULL, penalty = 0,
  min_n_to_chunk = 1000, min_seg = 1, max_k = length(x))
}
\arguments{
\item{x}{numeric, input variable (no NAs).}

\item{y}{numeric, result variable (no NAs, same length as x).}

\item{...}{not used, force later arguments by name.}

\item{w}{numeric, weights (no NAs, positive, same length as x).}

\item{penalty}{per-segment cost penalty.}

\item{min_n_to_chunk}{minimum n to subdivied problem.}

\item{min_seg}{positive integer, minimum segment size.}

\item{max_k}{maximum segments to divide into.}
}
\value{
a data frame appropriate for stats::approx().
}
\description{
Solve for a good set of right-exclusive x-cuts such that the 
overall graph of y~x is well-approximated by a piecewise linear
function.
}
\examples{

solve_for_partition(1:8, c(1, 2, 3, 4, 4, 3, 2, 1))

}
