% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppCGAL-package.R
\docType{package}
\name{RcppCGAL-package}
\alias{RcppCGAL}
\alias{RcppCGAL-package}
\title{RcppCGAL: Rcpp Integration for CGAL}
\description{
Creates a header only package to link to the CGAL (Computational Geometry Algorithms Library) header files in Rcpp. There are a variety of potential uses for the software such as Hilbert sorting, KDtree nearest neighbors, and convex hull algorithms. There is only one R function in this package, which returns the current version of the CGAL library included. For more information about how to use the header files, see the CGAL documentation at \url{https://www.cgal.org}. Currently includes the CGAL 5.5.2 stable release.
}
\examples{
\dontrun{
# To use this in a C++ file make sure you add an appropriate
# dependency in your header C++ code. Make sure to use CGAL/basic.h

#include <Rcpp.h>
// [[Rcpp::depends(RcppCGAL)]]
#include <CGAL/basic.h>

// function code

}
}
\references{
The CGAL Project. (2023). {CGAL} User and Reference Manual (5.5.2). Retrieved from <https://doc.cgal.org/5.4/Manual/packages.html>
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/ericdunipace/RcppCGAL/issues}
}

}
\author{
\strong{Maintainer}: Eric Dunipace \email{edunipace@mail.harvard.edu} (\href{https://orcid.org/0000-0001-8909-213X}{ORCID})

}
