# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' linear model fitting function based on RcppBlaze
#'
#' \code{fastLmPure} provides the estimates of the linear model based on \code{RcppBlaze}.
#'
#' \code{fastLm} estimates the linear model using the \code{solve}.
#'
#' @param X A model matrix.
#' @param y A response vector.
#' @param type A integer. 0 is QR solver, 1 is LLT solver and 2 is LDLT sovler.
#' @return A list containing coefficients, standard errors, rank of model matrix,
#'   degree of freedom of residuals, residuals, the standard deviation of random errors and
#'   fitted values.
#' @examples
#' # according to fastLm example in RcppArmadillo
#' data(trees, package="datasets")
#' flm <- fastLmPure(cbind(1, log(trees$Girth)), log(trees$Volume), 0)
#' print(flm)
#' @export
fastLmPure <- function(X, y, type) {
    .Call(`_RcppBlaze_fastLmPure`, X, y, type)
}

blaze_version <- function(single) {
    .Call(`_RcppBlaze_blaze_version`, single)
}

Blaze_SSE <- function() {
    .Call(`_RcppBlaze_Blaze_SSE`)
}

Blaze_AVX <- function() {
    .Call(`_RcppBlaze_Blaze_AVX`)
}

Blaze_AVX2 <- function() {
    .Call(`_RcppBlaze_Blaze_AVX2`)
}

Blaze_MIC <- function() {
    .Call(`_RcppBlaze_Blaze_MIC`)
}

Blaze_FMA <- function() {
    .Call(`_RcppBlaze_Blaze_FMA`)
}

