% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompadreDB-Methods.R
\name{CompadreDB-Methods}
\alias{CompadreDB-Methods}
\alias{as.data.frame.CompadreDB}
\alias{as_tibble.CompadreDB}
\alias{head.CompadreDB}
\alias{tail.CompadreDB}
\alias{names.CompadreDB}
\alias{dim.CompadreDB}
\alias{merge.CompadreDB}
\alias{NumberAcceptedSpecies}
\alias{NumberAcceptedSpecies,CompadreDB-method}
\alias{NumberStudies}
\alias{NumberStudies,CompadreDB-method}
\alias{NumberMatrices}
\alias{NumberMatrices,CompadreDB-method}
\title{Methods for CompadreDB objects}
\usage{
\method{as.data.frame}{CompadreDB}(x, ...)

\method{as_tibble}{CompadreDB}(
  x,
  .rows = NULL,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  rownames = NULL,
  ...
)

\method{head}{CompadreDB}(x, n = 6L, ...)

\method{tail}{CompadreDB}(x, n = 6L, ...)

\method{names}{CompadreDB}(x)

\method{dim}{CompadreDB}(x)

\method{merge}{CompadreDB}(x, y, ...)

NumberAcceptedSpecies(object)

\S4method{NumberAcceptedSpecies}{CompadreDB}(object)

NumberStudies(object)

\S4method{NumberStudies}{CompadreDB}(object)

NumberMatrices(object)

\S4method{NumberMatrices}{CompadreDB}(object)
}
\arguments{
\item{x, object}{A CompadreDB object}

\item{...}{additional arguments}

\item{.rows}{passed to [tibble::as_tibble()]}

\item{.name_repair}{passed to [tibble::as_tibble()]}

\item{rownames}{passed to [tibble::as_tibble()]}

\item{n}{The number of rows to extract}

\item{y}{A data.frame to merge with x}
}
\value{
No return value, called for side effects
}
\description{
This page describes a variety of methods that can be used with CompadreDB
objects, including common data frame operations (\code{head}, \code{names},
and \code{merge}), conversion methods (\code{as.data.frame} and
\code{as_tibble}), and methods to calculate the number of species
(\code{NumberAcceptedSpecies}), studies (\code{NumberStudies}), or matrices
(\code{NumberMatrices}).
}
