\name{Menu.Quantitative}
\alias{Menu.Quantitative}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Designs specifically tailored to quantitative factors}
\description{This menu covers classical response surface designs (central composite 
and Box-Behnken) as well as so-called latin-hypercube samples for 
factors that can and should be set to many different levels. This 
help file is about when to apply which of these.}
%- maybe also 'usage' for other objects documented here.
\section{Central composite designs}{
Central composite designs can be generated from scratch or as an extension to 
2-level full or fractional factorials generated with the 2-level dialogue 
or with function \code{FrF2}. 
Their rationale is explained \code{\link[DoE.wrapper:CentralCompositeDesigns]{here}}. 
They usually have five different levels per experimental factor.

Box-Behnken designs have only three levels for each factor. They are explained 
\code{\link[DoE.wrapper:bbd.design]{here}}. They can not be generated by augmenting 
an existing design.

Latin hypercube designs - if used with optimization which is strongly recommended - 
try to fill the experimental space with points in an efficient way. Note that they are 
NOT trying to optimize the design w.r.t. a specific statistical model. Such optimal plans 
have not been implemented yet (they are available outside the R-commander with 
package \code{AlgDesign}).
}

\references{ 
    Box G. E. P, Hunter, W. C. and Hunter, J. S. (2005) 
    \emph{Statistics for Experimenters, 2nd edition}.
    New York: Wiley.
 }
\author{ Ulrike Groemping }
\seealso{ See Also \code{\link[DoE.wrapper]{ccd.design}} and \code{\link[DoE.wrapper]{ccd.augment}} 
for the functions behind the central composite designs, 
\code{\link[DoE.wrapper]{bbd.design}} for the function behind the Box-Behnken designs, 
and \code{\link[DoE.wrapper]{lhs.design}} for the function behind the latin hypercube samples. 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ design }
\keyword{ array }% __ONLY ONE__ keyword per line
