\name{numSummary}
\alias{numSummary}
\alias{print.numSummary}

\title{Mean, Standard Deviation, and Quantiles for Numeric Variables}
\description{
\code{numSummary} creates neatly formatted tables of means, standard deviations, and quantiles of numeric variables.
}
\usage{
numSummary(data, statistics=c("mean", "sd", "quantiles"), 
    quantiles=c(0, .25, .5, .75, 1), groups)
    
\method{print}{numSummary}(x, ...)
}

\arguments{
  \item{data}{a numeric vector, matrix, or data frame.}
  \item{statistics}{any of \code{"mean"}, \code{"sd"}, or \code{"quantiles"}, 
    defaulting to all three.}
  \item{quantiles}{quantiles to report; default is \code{c(0, 0.25, 0.5, 0.75, 1)}.}
  \item{groups}{optional variable, typically a factor, to be used to partition the data.}
  \item{x}{object of class \code{"numSummary"} to print.}
  \item{\dots}{arguments to pass down from the print method.}
}

\value{
\code{numSummary} returns an object of class \code{"numSummary"} containing the table of 
statistics to be reported along with information on missing data, if there are any.}
}

\author{John Fox \email{jfox@mcmaster.ca}}


\seealso{\code{\link[base]{mean}}, \code{\link[stats]{sd}}, \code{\link[stats]{quantile}}.}

\examples{
library(car)
Prestige[1, "income"] <- NA
numSummary(Prestige[,c("income", "education")])
numSummary(Prestige[,c("income", "education")], groups=Prestige$type)
remove(Prestige)
}

\keyword{misc}

