% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{loadSummary}
\alias{loadSummary}
\title{Summaries loading}
\usage{
loadSummary(filename.csv)
}
\arguments{
\item{filename.csv}{character vector specifying the name and directory of the csv file.}
}
\value{
res data.frame containing the clusters summaries.
}
\description{
Load the clusters summaries results (min, max, sum, average, sd) from a csv file.
}
\details{
loadSummary loads the clusters summaries results (min, max, sum, average, sd) from a csv file
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1)
res <- KmeansQuick(x$features$initial$x, K=3)
labels <- formatLabelSample(res$cluster, x)
cluster.summary <- clusterSummary(x, labels)

tf2 <- tempfile()
saveSummary(basename(tf2), cluster.summary, dirname(tf2))

loadSummary(tf2)
 

}
\seealso{
\code{\link{saveSummary}}
}
\keyword{internal}
