% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{saveSummary}
\alias{saveSummary}
\title{Clusters summaries saving}
\usage{
saveSummary(filename.csv, cluster.summary, dir, info = NULL)
}
\arguments{
\item{filename.csv}{character vector specifying the path and the name of the csv file.}

\item{cluster.summary}{data.frame containing the clusters summaries results.}

\item{dir}{character vector specifying the directory where to save the csv file.}

\item{info}{character vector about sample or clustering.}
}
\value{
csv file containing clusters summaries results.
}
\description{
Save clusters summaries results in a csv file.
}
\details{
saveSummary saves clusters summaries results in a csv file
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1)
res <- KmeansQuick(x$features$initial$x, K=3)
labels <- formatLabelSample(res$cluster, x)
cluster.summary <- clusterSummary(x, labels)

tf2 <- tempfile()
saveSummary(basename(tf2), cluster.summary, dirname(tf2))


}
\seealso{
\code{\link{loadSummary}}
}
