% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{importLabelSample}
\alias{importLabelSample}
\title{Labels importation}
\usage{
importLabelSample(label, data.sample, noise.cluster = "Noise")
}
\arguments{
\item{label}{vector of labels.}

\item{data.sample}{sample object.}

\item{noise.cluster}{character name of the cluster "Noise".}
}
\value{
new.labels imported labels.
}
\description{
Import labels and add cleaned observations as 'noise'.
}
\details{
importLabelSample imports labels
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())
res <- KmeansQuick(x$features$initial$x, K=3)

new.labels <- importLabelSample(res$cluster, x)


}
\keyword{internal}
