% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rchoice.methods.R
\name{vcov.Rchoice}
\alias{vcov.Rchoice}
\title{vcov method for Rchoice objects}
\usage{
\method{vcov}{Rchoice}(object, what = c("coefficient", "ranp"),
  type = c("cov", "cor", "sd"), se = FALSE, digits = max(3,
  getOption("digits") - 2), ...)
}
\arguments{
\item{object}{a fitted model of class \code{Rchoice},}

\item{what}{indicates which covariance matrix has to be extracted. The default is \code{coefficient}, in this case the \code{vcov} behaves as usual. If \code{what = "ranp"} the covariance matrix of the random parameters is returned as default,}

\item{type}{if the model is estimated with random parameters, then this argument indicates what matrix should be returned. If \code{type = "cov"}, then the covariance matrix of the random parameters is returned; if \code{type = "cor"} then the correlation matrix of the random parameters is returned; if \code{type = "sd"} then the standard deviation of the random parameters is returned,}

\item{se}{if \code{TRUE} \code{type = "cov"} then the standard error of the covariance matrix of the random parameters is returned; if \code{TRUE} \code{type = "sd"} the standard error of the standard deviation of the random parameter is returned. This argument if valid only if the model is estimated using correlated random parameters,}

\item{digits}{number of digits,}

\item{...}{further arguments}
}
\description{
The \code{vcov} method for \code{Rchoice} objects extracts the covariance matrix of the coefficients or the random parameters. It also allows to get the standard errors for the variance-covariance matrix of the random parameters
}
\details{
This new interface replaces the \code{cor.Rchoice}, \code{cov.Rchoice} and \code{se.cov.Rchoice} functions which are deprecated.
}
\seealso{
\code{\link[Rchoice]{Rchoice}} for the estimation of discrete choice models with random parameters.
}

