% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rchoice.methods.R
\name{effect.Rchoice}
\alias{effect.Rchoice}
\title{Get the conditional individual coefficients}
\usage{
\method{effect}{Rchoice}(object, par = NULL, effect = c("cv", "ce"), wrt = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{Rchoice},}

\item{par}{a string giving the name of the variable with random parameter,}

\item{effect}{a string indicating what should be computed: the conditional expectation of the individual coefficients "\code{ce}", or the conditional expectation of the individual compensating variations "\code{cv}",}

\item{wrt}{a string indicating respect to which variable the compensating variation should be computed,}

\item{...}{further arguments. Ignored.}
}
\value{
A named list where ``mean'' contains the individuals' conditional mean for the random parameter or compensating variation, and where `sd.est' contains their standard errors.
}
\description{
This a helper function to obtain the individuals' conditional estimate of the random parameters or compensating variations.
}
\examples{
\donttest{
# Poisson with random parameters
data("Articles")
poisson.ran <- Rchoice(art ~ fem + mar + kid5 + phd + ment, 
                       data = Articles,  family = poisson,
                       ranp = c(kid5 = "n", phd = "n", ment = "n"), 
                       R = 10)

## Get the individuals' conditional mean and their standard errors for ment                      
bi.ment <- effect(poisson.ran, par = "ment", effect = "ce")
summary(bi.ment$mean)
summary(bi.ment$sd.est)
}
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge university press.
}
}
\seealso{
\code{\link[Rchoice]{Rchoice}} for the estimation of different discrete choice models with individual parameters.
}
