% Generated by roxygen2 (4.0.1): do not edit by hand
\name{market.api.query.btce}
\alias{market.api.query.btce}
\title{Send request to btce market API}
\usage{
market.api.query.btce(url, key, secret, req = list(),
  verbose = getOption("Rbitcoin.verbose", 0))
}
\arguments{
\item{url}{character with url on which query needs to be passed.}

\item{key}{character API key used in private API calls.}

\item{secret}{character API secret used in private API calls.}

\item{req}{list of object passed to API: price and amount of opening order, id of cancelling order, etc. See note.}

\item{verbose}{integer. Rbitcoin processing messages, print to console if \code{verbose > 0}, each subfunction reduce \code{verbose} by 1. If missing then \code{getOption("Rbitcoin.verbose",0)} is used, by default \code{0}.}
}
\value{
R object created by \code{fromJSON} decoded result from market's API call.
}
\description{
Send request to btce market API.
}
\note{
Market specific btce \code{method} param should be provided in \code{req} object.
}
\examples{
\dontrun{
# ticker
market.api.query.btce(url = 'https://btc-e.com/api/2/btc_usd/ticker')
# wallet
market.api.query.btce(url = 'https://btc-e.com/tapi',
                      req = list(method = 'getInfo'),
                      key = '', secret = '')
}
}
\references{
\url{https://btc-e.com/api/documentation}
}
\seealso{
\code{\link{market.api.query}}
}

