% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_gauss_matrix.R
\name{form_gauss_matrix}
\alias{form_gauss_matrix}
\title{Form Gaussian Matrix}
\usage{
form_gauss_matrix(n_rows, n_cols, JLT, eps = 0.1)
}
\arguments{
\item{n_rows}{- number of rows in the sample}

\item{n_cols}{- number of columns in the sample}

\item{JLT}{- Boolean to set JL transform (TRUE or FALSE)}

\item{eps}{- error tolerance level with default value 0.1}
}
\value{
Random Dense Matrix
}
\description{
In probability theory, Gaussian distribution is also called as normal distribution
 It is a continuous probability distribution used to represent real-valued random variables
The elements in the random matrix are drawn from N(0,1/k),
where k value calculated based on JL - Lemma.
}
\details{
The function uses pnorm() function from stats package to generate random matrix with mean is zero and
standard deviation is 1/sqrt(k),  where k is the minimum number of dimension return from the find_dim_JL() function
}
\examples{
# Load Library
library(RandPro)

# Without JLT
mat <- form_gauss_matrix(600,1000,FALSE)

# With JLT of eps = 0.5
mat <- form_gauss_matrix(300,100000,TRUE,0.5)

# With JLT of default eps value = 0.1
mat <- form_gauss_matrix(300,100000,TRUE)
}
\author{
Aghila G

Siddharth R
}
\references{
[1] N.I.R. Ailon and B.Chazelle, "The Fast Johnson Lindenstrauss Transform and Approximate Nearest Neighbors(2009)"
}
\keyword{Dimension_Reduction,}
\keyword{Gaussian-Distribution}
\keyword{Johnson-Lindenstrauss_Lemma,}
\keyword{RandomProjection,}

