% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{recalculateStress}
\alias{recalculateStress}
\title{Recalculate the stress associated with an acmap optimization}
\usage{
recalculateStress(map, optimization_number = 1)
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The optimization number}
}
\value{
Returns the recalculated map stress for a given optimization
}
\description{
Recalculates the stress associated with the currently selected or
user-specifed optimization.
}
\seealso{
See \code{pointStress()} for getting the stress of individual points.

Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapDistances}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
