% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{RacOptimizer.options}
\alias{RacOptimizer.options}
\title{Set acmap optimization options}
\usage{
RacOptimizer.options(
  dim_annealing = FALSE,
  method = "L-BFGS",
  maxit = 1000,
  num_basis = 10,
  armijo_constant = 1e-04,
  wolfe = 0.9,
  min_gradient_norm = 1e-06,
  factr = 1e-15,
  max_line_search_trials = 50,
  min_step = 1e-20,
  max_step = 1e+20,
  num_cores = getOption("RacOptimizer.num_cores"),
  report_progress = NULL,
  ignore_disconnected = FALSE,
  progress_bar_length = options()$width
)
}
\arguments{
\item{dim_annealing}{Should dimensional annealing be performed}

\item{method}{The optimization method to use}

\item{maxit}{The maximum number of iterations to use in the optimizer}

\item{num_basis}{Number of memory points to be stored (default 10).}

\item{armijo_constant}{Controls the accuracy of the line search routine for determining the Armijo condition.}

\item{wolfe}{Parameter for detecting the Wolfe condition.}

\item{min_gradient_norm}{Minimum gradient norm required to continue the optimization.}

\item{factr}{Minimum relative function value decrease to continue the optimization.}

\item{max_line_search_trials}{The maximum number of trials for the line search (before giving up).}

\item{min_step}{The minimum step of the line search.}

\item{max_step}{The maximum step of the line search.}

\item{num_cores}{The number of cores to run in parallel when running optimizations}

\item{report_progress}{Should progress be reported}

\item{ignore_disconnected}{Should the check for disconnected points be skipped}

\item{progress_bar_length}{Progress bar length when progress is reported}
}
\value{
Returns a named list of optimizer options
}
\description{
This function facilitates setting options for the acmap optimizer process by
returning a list of option settings.
}
\details{
For more details, for example on "dimensional annealing" see
\code{vignette("intro-to-antigenic-cartography")}. For details on optimizer
settings like \code{maxit} see the underlying optimizer documentation at
\href{https://ensmallen.org/}{ensmallen.org}.
}
\seealso{
Other map optimization functions: 
\code{\link{make.acmap}()},
\code{\link{moveTrappedPoints}()},
\code{\link{optimizeMap}()},
\code{\link{randomizeCoords}()},
\code{\link{relaxMapOneStep}()},
\code{\link{relaxMap}()}
}
\concept{map optimization functions}
