% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{Seurat2SCseq}
\alias{Seurat2SCseq}
\title{Converting a Seurat object to a RaceID/VarID object}
\usage{
Seurat2SCseq(Se, rseed = 12345)
}
\arguments{
\item{Se}{\pkg{Seurat} object.}

\item{rseed}{Integer number. Random seed for sampling cluster colours.}
}
\value{
\pkg{RaceID} \code{SCseq} object.
}
\description{
This function expects a class \code{Seurat} object from the \pkg{Seurat} package as input and converts this into a \pkg{RaceID} \code{SCseq} object. The function transfers the counts, initializes \code{ndata} and \code{fdata} without further filtering, transfers the PCA cell embeddings from the \code{Seurat} object to \code{dimRed}, transfers the clustering partition, and \code{umap} and \code{tsne} dimensional reduction (if available). CAUTION: Cluster numbers in RaceID start at 1 by default. Hence, all Seurat cluster numbers are shifted by 1.
}
