% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaRank.R
\name{RaRank}
\alias{RaRank}
\title{Rank the features by selected percentages provided by the output from \code{RaScreen}.}
\usage{
RaRank(object, selected.num = "all positive", iteration = object$iteration)
}
\arguments{
\item{object}{output from \code{RaScreen}.}

\item{selected.num}{the number of selected variables. User can either choose from the following popular options or input an positive integer no larger than the dimension.
\itemize{
\item 'all positive': the number of variables with positive selected percentage.
\item 'D': floor(D), where D is the maximum of ramdom subspace size.
\item '1.5D': floor(1.5D).
\item '2D': floor(2D).
\item '3D': floor(3D).
\item 'n/logn': floor(n/logn), where n is the sample size.
\item '1.5n/logn': floor(1.5n/logn).
\item '2n/logn': floor(2n/logn).
\item '3n/logn': floor(3n/logn).
\item 'n-1': the sample size n - 1.
\item 'p': the dimension p.
}}

\item{iteration}{indicates results from which iteration to use. It should be an positive integer. Default = the maximal interation round used by the output from \code{RaScreen}.}
}
\value{
Selected variables (indexes).
}
\description{
Rank the features by selected percentages provided by the output from \code{RaScreen}.
}
\examples{

\dontrun{
set.seed(0, kind = "L'Ecuyer-CMRG")
train.data <- RaModel("screening", 1, n = 100, p = 100)
xtrain <- train.data$x
ytrain <- train.data$y

# test RaSE screening with linear regression model and BIC
fit <- RaScreen(xtrain, ytrain, B1 = 100, B2 = 50, iteration = 0, model = 'lm',
cores = 2, criterion = 'bic')

# Select n/logn variables
RaRank(fit, selected.num = "n/logn")
}
}
\references{
Tian, Y. and Feng, Y., 2021. RaSE: Random subspace ensemble classification. Journal of Machine Learning Research, 22, to appear.
}
