% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooroh_accessor.R
\name{realized}
\alias{realized}
\title{Extracts the realized autozygosity from the zres object}
\usage{
realized(zres, classNum = NULL)
}
\arguments{
\item{zres}{The name of the zres object created by the zoorun function.}

\item{classNum}{An array with the number of the classes to extract. All classes
are extracted by default.}
}
\value{
The function returns a data frame with one row per individual and one column
per extracted classes. In addition, it gives names to the columns. For a pre-defined
 model, the names of HBD classes are "R_X" where X is the rate of the corresponding
class. For a model with rate estimation, the names of the HBD classes are
"HBDclassX" where X is the number of the HBD class. For non-HBD classes, we use "NonHBD".
}
\description{
Extracts the realized autozygosity from the zres object. Extraction is performed
for the indicated classes (all by default) and names are added to the columns.
}
