/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WekaException;

public class OneR
extends AbstractClassifier
implements TechnicalInformationHandler,
Sourcable {
    static final long serialVersionUID = -2459427002147861445L;
    private OneRRule m_rule;
    private int m_minBucketSize = 6;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "Class for building and using a 1R classifier; in other words, uses the minimum-error attribute for prediction, discretizing numeric attributes. For more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "R.C. Holte");
        result.setValue(TechnicalInformation.Field.YEAR, "1993");
        result.setValue(TechnicalInformation.Field.TITLE, "Very simple classification rules perform well on most commonly used datasets");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "11");
        result.setValue(TechnicalInformation.Field.PAGES, "63-91");
        return result;
    }

    public double classifyInstance(Instance inst) throws Exception {
        int v;
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.classifyInstance(inst);
        }
        if (inst.isMissing(this.m_rule.m_attr)) {
            if (this.m_rule.m_missingValueClass != -1) {
                return this.m_rule.m_missingValueClass;
            }
            return 0.0;
        }
        if (this.m_rule.m_attr.isNominal()) {
            v = (int)inst.value(this.m_rule.m_attr);
        } else {
            for (v = 0; v < this.m_rule.m_breakpoints.length && inst.value(this.m_rule.m_attr) >= this.m_rule.m_breakpoints[v]; ++v) {
            }
        }
        return this.m_rule.m_classifications[v];
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        boolean noRule = true;
        this.getCapabilities().testWithFail(instances);
        Instances data = new Instances(instances);
        data.deleteWithMissingClass();
        if (data.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(data);
            return;
        }
        this.m_ZeroR = null;
        Enumeration enu = instances.enumerateAttributes();
        while (enu.hasMoreElements()) {
            try {
                OneRRule r = this.newRule((Attribute)enu.nextElement(), data);
                if (noRule || r.m_correct > this.m_rule.m_correct) {
                    this.m_rule = r;
                }
                noRule = false;
            }
            catch (Exception ex) {}
        }
        if (noRule) {
            throw new WekaException("No attributes found to work with!");
        }
    }

    public OneRRule newRule(Attribute attr, Instances data) throws Exception {
        int[] missingValueCounts = new int[data.classAttribute().numValues()];
        OneRRule r = attr.isNominal() ? this.newNominalRule(attr, data, missingValueCounts) : this.newNumericRule(attr, data, missingValueCounts);
        r.m_missingValueClass = Utils.maxIndex(missingValueCounts);
        if (missingValueCounts[r.m_missingValueClass] == 0) {
            r.m_missingValueClass = -1;
        } else {
            r.m_correct += missingValueCounts[r.m_missingValueClass];
        }
        return r;
    }

    public OneRRule newNominalRule(Attribute attr, Instances data, int[] missingValueCounts) throws Exception {
        int[][] counts = new int[attr.numValues()][data.classAttribute().numValues()];
        Enumeration enu = data.enumerateInstances();
        while (enu.hasMoreElements()) {
            Instance i = (Instance)enu.nextElement();
            if (i.isMissing(attr)) {
                int n = (int)i.classValue();
                missingValueCounts[n] = missingValueCounts[n] + 1;
                continue;
            }
            int[] nArray = counts[(int)i.value(attr)];
            int n = (int)i.classValue();
            nArray[n] = nArray[n] + 1;
        }
        OneRRule r = new OneRRule(data, attr);
        for (int value = 0; value < attr.numValues(); ++value) {
            int best;
            ((OneRRule)r).m_classifications[value] = best = Utils.maxIndex(counts[value]);
            r.m_correct += counts[value][best];
        }
        return r;
    }

    public OneRRule newNumericRule(Attribute attr, Instances data, int[] missingValueCounts) throws Exception {
        data = new Instances(data);
        int[] classifications = new int[data.numInstances()];
        double[] breakpoints = new double[data.numInstances()];
        int[] counts = new int[data.classAttribute().numValues()];
        int correct = 0;
        int lastInstance = data.numInstances();
        data.sort(attr);
        while (lastInstance > 0 && data.instance(lastInstance - 1).isMissing(attr)) {
            int n = (int)data.instance(--lastInstance).classValue();
            missingValueCounts[n] = missingValueCounts[n] + 1;
        }
        int i = 0;
        int cl = 0;
        while (i < lastInstance) {
            int it;
            int j;
            for (j = 0; j < counts.length; ++j) {
                counts[j] = 0;
            }
            do {
                int n = it = (int)data.instance(i++).classValue();
                counts[n] = counts[n] + 1;
            } while (counts[it] < this.m_minBucketSize && i < lastInstance);
            while (i < lastInstance && (int)data.instance(i).classValue() == it) {
                int n = it;
                counts[n] = counts[n] + 1;
                ++i;
            }
            while (i < lastInstance && data.instance(i - 1).value(attr) == data.instance(i).value(attr)) {
                int n = (int)data.instance(i++).classValue();
                counts[n] = counts[n] + 1;
            }
            for (j = 0; j < counts.length; ++j) {
                if (counts[j] <= counts[it]) continue;
                it = j;
            }
            if (cl > 0) {
                if (counts[classifications[cl - 1]] == counts[it]) {
                    it = classifications[cl - 1];
                }
                if (it == classifications[cl - 1]) {
                    --cl;
                }
            }
            correct += counts[it];
            classifications[cl] = it;
            if (i < lastInstance) {
                breakpoints[cl] = (data.instance(i - 1).value(attr) + data.instance(i).value(attr)) / 2.0;
            }
            ++cl;
        }
        if (cl == 0) {
            throw new Exception("Only missing values in the training data!");
        }
        OneRRule r = new OneRRule(data, attr, cl);
        r.m_correct = correct;
        for (int v = 0; v < cl; ++v) {
            ((OneRRule)r).m_classifications[v] = classifications[v];
            if (v >= cl - 1) continue;
            ((OneRRule)r).m_breakpoints[v] = breakpoints[v];
        }
        return r;
    }

    public Enumeration listOptions() {
        String string = "\tThe minimum number of objects in a bucket (default: 6).";
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option(string, "B", 1, "-B <minimum bucket size>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String bucketSizeString = Utils.getOption('B', options);
        this.m_minBucketSize = bucketSizeString.length() != 0 ? Integer.parseInt(bucketSizeString) : 6;
    }

    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        options[current++] = "-B";
        options[current++] = "" + this.m_minBucketSize;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toSource(String className) throws Exception {
        StringBuffer result = new StringBuffer();
        if (this.m_ZeroR != null) {
            result.append(((ZeroR)this.m_ZeroR).toSource(className));
        } else {
            int i;
            result.append("class " + className + " {\n");
            result.append("  public static double classify(Object[] i) {\n");
            result.append("    // chosen attribute: " + this.m_rule.m_attr.name() + " (" + this.m_rule.m_attr.index() + ")\n");
            result.append("\n");
            result.append("    // missing value?\n");
            result.append("    if (i[" + this.m_rule.m_attr.index() + "] == null)\n");
            if (this.m_rule.m_missingValueClass != -1) {
                result.append("      return Double.NaN;\n");
            } else {
                result.append("      return 0;\n");
            }
            result.append("\n");
            result.append("    // prediction\n");
            result.append("    double v = 0;\n");
            result.append("    double[] classifications = new double[]{" + Utils.arrayToString(this.m_rule.m_classifications) + "};");
            result.append(" // ");
            for (i = 0; i < this.m_rule.m_classifications.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.m_rule.m_class.value(this.m_rule.m_classifications[i]));
            }
            result.append("\n");
            if (this.m_rule.m_attr.isNominal()) {
                for (i = 0; i < this.m_rule.m_attr.numValues(); ++i) {
                    result.append("    ");
                    if (i > 0) {
                        result.append("else ");
                    }
                    result.append("if (((String) i[" + this.m_rule.m_attr.index() + "]).equals(\"" + this.m_rule.m_attr.value(i) + "\"))\n");
                    result.append("      v = " + i + "; // " + this.m_rule.m_class.value(this.m_rule.m_classifications[i]) + "\n");
                }
            } else {
                result.append("    double[] breakpoints = new double[]{" + Utils.arrayToString(this.m_rule.m_breakpoints) + "};\n");
                result.append("    while (v < breakpoints.length && \n");
                result.append("           ((Double) i[" + this.m_rule.m_attr.index() + "]) >= breakpoints[(int) v]) {\n");
                result.append("      v++;\n");
                result.append("    }\n");
            }
            result.append("    return classifications[(int) v];\n");
            result.append("  }\n");
            result.append("}\n");
        }
        return result.toString();
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        if (this.m_rule == null) {
            return "OneR: No model built yet.";
        }
        return this.m_rule.toString();
    }

    public String minBucketSizeTipText() {
        return "The minimum bucket size used for discretizing numeric attributes.";
    }

    public int getMinBucketSize() {
        return this.m_minBucketSize;
    }

    public void setMinBucketSize(int v) {
        this.m_minBucketSize = v;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7684 $");
    }

    public static void main(String[] argv) {
        OneR.runClassifier(new OneR(), argv);
    }

    private class OneRRule
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 1152814630957092281L;
        private Attribute m_class;
        private int m_numInst;
        private Attribute m_attr;
        private int m_correct;
        private int[] m_classifications;
        private int m_missingValueClass = -1;
        private double[] m_breakpoints;

        public OneRRule(Instances data, Attribute attribute) throws Exception {
            this.m_class = data.classAttribute();
            this.m_numInst = data.numInstances();
            this.m_attr = attribute;
            this.m_correct = 0;
            this.m_classifications = new int[this.m_attr.numValues()];
        }

        public OneRRule(Instances data, Attribute attribute, int nBreaks) throws Exception {
            this.m_class = data.classAttribute();
            this.m_numInst = data.numInstances();
            this.m_attr = attribute;
            this.m_correct = 0;
            this.m_classifications = new int[nBreaks];
            this.m_breakpoints = new double[nBreaks - 1];
        }

        public String toString() {
            try {
                StringBuffer text = new StringBuffer();
                text.append(this.m_attr.name() + ":\n");
                for (int v = 0; v < this.m_classifications.length; ++v) {
                    text.append("\t");
                    if (this.m_attr.isNominal()) {
                        text.append(this.m_attr.value(v));
                    } else if (v < this.m_breakpoints.length) {
                        text.append("< " + this.m_breakpoints[v]);
                    } else if (v > 0) {
                        text.append(">= " + this.m_breakpoints[v - 1]);
                    } else {
                        text.append("not ?");
                    }
                    text.append("\t-> " + this.m_class.value(this.m_classifications[v]) + "\n");
                }
                if (this.m_missingValueClass != -1) {
                    text.append("\t?\t-> " + this.m_class.value(this.m_missingValueClass) + "\n");
                }
                text.append("(" + this.m_correct + "/" + this.m_numInst + " instances correct)\n");
                return text.toString();
            }
            catch (Exception e) {
                return "Can't print OneR classifier!";
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 7684 $");
        }
    }
}

