/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import org.w3c.dom.Element;
import weka.classifiers.CostMatrix;
import weka.core.Matrix;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.xml.XMLDocument;
import weka.core.xml.XMLSerialization;

public class XMLBasicSerialization
extends XMLSerialization {
    public static final String VAL_MAPPING = "mapping";
    public static final String VAL_KEY = "key";
    public static final String VAL_VALUE = "value";
    public static final String VAL_CELLS = "cells";

    public void clear() throws Exception {
        super.clear();
        this.m_CustomMethods.register(this, DefaultListModel.class, "DefaultListModel");
        this.m_CustomMethods.register(this, HashMap.class, "Map");
        this.m_CustomMethods.register(this, HashSet.class, "Collection");
        this.m_CustomMethods.register(this, Hashtable.class, "Map");
        this.m_CustomMethods.register(this, LinkedList.class, "Collection");
        this.m_CustomMethods.register(this, Properties.class, "Map");
        this.m_CustomMethods.register(this, Stack.class, "Collection");
        this.m_CustomMethods.register(this, TreeMap.class, "Map");
        this.m_CustomMethods.register(this, TreeSet.class, "Collection");
        this.m_CustomMethods.register(this, Vector.class, "Collection");
        this.m_CustomMethods.register(this, weka.core.matrix.Matrix.class, "Matrix");
        this.m_CustomMethods.register(this, Matrix.class, "MatrixOld");
        this.m_CustomMethods.register(this, CostMatrix.class, "CostMatrixOld");
    }

    public Element writeDefaultListModel(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        DefaultListModel model = (DefaultListModel)o;
        Element node = this.addElement(parent, name, o.getClass().getName(), false);
        for (int i = 0; i < model.getSize(); ++i) {
            this.invokeWriteToXML(node, model.get(i), Integer.toString(i));
        }
        return node;
    }

    public Object readDefaultListModel(Element node) throws Exception {
        Element child;
        int i;
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        Vector<Element> children = XMLDocument.getChildTags(node);
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int index = children.size() - 1;
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            int currIndex = Integer.parseInt(child.getAttribute("name"));
            if (currIndex <= index) continue;
            index = currIndex;
        }
        model.setSize(index + 1);
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            model.set(Integer.parseInt(child.getAttribute("name")), this.invokeReadFromXML(child));
        }
        return model;
    }

    public Element writeCollection(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Iterator iter = ((Collection)o).iterator();
        Element node = this.addElement(parent, name, o.getClass().getName(), false);
        int i = 0;
        while (iter.hasNext()) {
            this.invokeWriteToXML(node, iter.next(), Integer.toString(i));
            ++i;
        }
        return node;
    }

    public Object readCollection(Element node) throws Exception {
        Element child;
        int i;
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        Vector<Element> children = XMLDocument.getChildTags(node);
        Vector<Object> v = new Vector<Object>();
        int index = children.size() - 1;
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            int currIndex = Integer.parseInt(child.getAttribute("name"));
            if (currIndex <= index) continue;
            index = currIndex;
        }
        v.setSize(index + 1);
        for (i = 0; i < children.size(); ++i) {
            child = children.get(i);
            v.set(Integer.parseInt(child.getAttribute("name")), this.invokeReadFromXML(child));
        }
        Collection coll = (Collection)Utils.cast(Class.forName(node.getAttribute("class")).newInstance());
        coll.addAll(v);
        return coll;
    }

    public Element writeMap(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Map map = (Map)o;
        Iterator iter = map.keySet().iterator();
        Element node = this.addElement(parent, name, o.getClass().getName(), false);
        while (iter.hasNext()) {
            Object key = iter.next();
            Element child = this.addElement(node, VAL_MAPPING, Object.class.getName(), false);
            this.invokeWriteToXML(child, key, VAL_KEY);
            this.invokeWriteToXML(child, map.get(key), VAL_VALUE);
        }
        return node;
    }

    public Object readMap(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        Map map = (Map)Utils.cast(Class.forName(node.getAttribute("class")).newInstance());
        Vector<Element> children = XMLDocument.getChildTags(node);
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            Vector<Element> cchildren = XMLDocument.getChildTags(child);
            Object key = null;
            Object value = null;
            for (int n = 0; n < cchildren.size(); ++n) {
                Element cchild = cchildren.get(n);
                String name = cchild.getAttribute("name");
                if (name.equals(VAL_KEY)) {
                    key = this.invokeReadFromXML(cchild);
                    continue;
                }
                if (name.equals(VAL_VALUE)) {
                    value = this.invokeReadFromXML(cchild);
                    continue;
                }
                System.out.println("WARNING: '" + name + "' is not a recognized name for maps!");
            }
            map.put(key, value);
        }
        return map;
    }

    public Element writeMatrix(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        weka.core.matrix.Matrix matrix = (weka.core.matrix.Matrix)o;
        Element node = this.addElement(parent, name, o.getClass().getName(), false);
        this.invokeWriteToXML(node, matrix.getArray(), VAL_CELLS);
        return node;
    }

    public Object readMatrix(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        weka.core.matrix.Matrix matrix = null;
        Vector<Element> children = XMLDocument.getChildTags(node);
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            String name = child.getAttribute("name");
            if (!name.equals(VAL_CELLS)) continue;
            Object o = this.invokeReadFromXML(child);
            matrix = new weka.core.matrix.Matrix((double[][])o);
        }
        return matrix;
    }

    public Element writeMatrixOld(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Matrix matrix = (Matrix)o;
        Element node = this.addElement(parent, name, o.getClass().getName(), false);
        double[][] array = new double[matrix.numRows()][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = matrix.getRow(i);
        }
        this.invokeWriteToXML(node, array, VAL_CELLS);
        return node;
    }

    public Object readMatrixOld(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        weka.core.matrix.Matrix matrixNew = (weka.core.matrix.Matrix)this.readMatrix(node);
        Matrix matrix = new Matrix(matrixNew.getArrayCopy());
        return matrix;
    }

    public Element writeCostMatrixOld(Element parent, Object o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        return this.writeMatrixOld(parent, o, name);
    }

    public Object readCostMatrixOld(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute("name"));
        }
        this.m_CurrentNode = node;
        weka.core.matrix.Matrix matrixNew = (weka.core.matrix.Matrix)this.readMatrix(node);
        StringWriter writer = new StringWriter();
        matrixNew.write(writer);
        CostMatrix matrix = new CostMatrix(new StringReader(writer.toString()));
        return matrix;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

