/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import weka.core.OptionHandler;
import weka.core.OptionMetadata;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Utils;

public class Option
implements RevisionHandler {
    private String m_Description;
    private String m_Synopsis;
    private String m_Name;
    private int m_NumArguments;

    public Option(String description, String name, int numArguments, String synopsis) {
        this.m_Description = description;
        this.m_Name = name;
        this.m_NumArguments = numArguments;
        this.m_Synopsis = synopsis;
    }

    public static Vector<Option> listOptionsForClassHierarchy(Class<?> childClazz, Class<?> oldestAncestorClazz) {
        Vector<Option> results = Option.listOptionsForClass(childClazz);
        Class<?> parent = childClazz;
        while ((parent = parent.getSuperclass()) != null) {
            results.addAll(Option.listOptionsForClass(parent));
            if (!parent.equals(oldestAncestorClazz)) continue;
        }
        return results;
    }

    protected static void addMethodsToList(Class<?> clazz, List<Method> methList) {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            methList.add(m);
        }
    }

    public static Vector<Option> listOptionsForClass(Class<?> clazz) {
        Class<?>[] interfaces;
        Vector<Option> results = new Vector<Option>();
        ArrayList<Method> allMethods = new ArrayList<Method>();
        Option.addMethodsToList(clazz, allMethods);
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            Option.addMethodsToList(c, allMethods);
        }
        Option[] unsorted = new Option[allMethods.size()];
        int[] opOrder = new int[allMethods.size()];
        for (int i = 0; i < opOrder.length; ++i) {
            opOrder[i] = Integer.MAX_VALUE;
        }
        int index = 0;
        for (Method m : allMethods) {
            Option option;
            String synopsis;
            OptionMetadata o = m.getAnnotation(OptionMetadata.class);
            if (o == null || o.commandLineParamName().length() <= 0) continue;
            opOrder[index] = o.displayOrder();
            String description = o.description();
            if (!description.startsWith("\t")) {
                description = "\t" + description;
            }
            description = description.replace("\n", "\n\t");
            String name = o.commandLineParamName();
            if (name.startsWith("-")) {
                name = name.substring(1, name.length());
            }
            if (!(synopsis = o.commandLineParamSynopsis()).startsWith("-")) {
                synopsis = "-" + synopsis;
            }
            int numParams = o.commandLineParamIsFlag() ? 0 : 1;
            unsorted[index] = option = new Option(description, name, numParams, synopsis);
            ++index;
        }
        int[] sortedOpts = Utils.sort(opOrder);
        for (int i = 0; i < opOrder.length; ++i) {
            if (opOrder[i] >= Integer.MAX_VALUE) continue;
            results.add(unsorted[sortedOpts[i]]);
        }
        return results;
    }

    public static String[] getOptionsForHierarchy(Object target, Class<?> oldestAncestorClazz) {
        ArrayList<String> options = new ArrayList<String>();
        for (String s : Option.getOptions(target, target.getClass())) {
            options.add(s);
        }
        Class<?> parent = target.getClass();
        while ((parent = parent.getSuperclass()) != null) {
            for (String s : Option.getOptions(target, parent)) {
                options.add(s);
            }
            if (!parent.equals(oldestAncestorClazz)) continue;
        }
        return options.toArray(new String[options.size()]);
    }

    public static String[] getOptions(Object target, Class<?> targetClazz) {
        ArrayList<String> options = new ArrayList<String>();
        try {
            PropertyDescriptor[] properties;
            Object[] args = new Object[]{};
            Class<?> parent = targetClazz.getSuperclass();
            BeanInfo bi = Introspector.getBeanInfo(targetClazz, parent);
            for (PropertyDescriptor p : properties = bi.getPropertyDescriptors()) {
                Object value;
                Method getter = p.getReadMethod();
                Method setter = p.getWriteMethod();
                if (getter == null || setter == null) continue;
                OptionMetadata parameterDescription = null;
                parameterDescription = getter.getAnnotation(OptionMetadata.class);
                if (parameterDescription == null) {
                    parameterDescription = setter.getAnnotation(OptionMetadata.class);
                }
                if (parameterDescription == null || parameterDescription.commandLineParamName().length() <= 0 || (value = getter.invoke(target, args)) == null) continue;
                if (!parameterDescription.commandLineParamIsFlag()) {
                    options.add("-" + parameterDescription.commandLineParamName());
                }
                if (value.getClass().isArray()) {
                    if (parameterDescription.commandLineParamIsFlag()) {
                        throw new IllegalArgumentException("Getter method for a command line flag should return a boolean value");
                    }
                    int index = 0;
                    for (Object element : (Object[])value) {
                        if (index > 0) {
                            options.add("-" + parameterDescription.commandLineParamName());
                        }
                        if (element instanceof OptionHandler) {
                            options.add(Option.getOptionStringForOptionHandler((OptionHandler)element));
                        } else {
                            options.add(element.toString());
                        }
                        ++index;
                    }
                    continue;
                }
                if (value instanceof OptionHandler) {
                    if (parameterDescription.commandLineParamIsFlag()) {
                        throw new IllegalArgumentException("Getter method for a command line flag should return a boolean value");
                    }
                    options.add(Option.getOptionStringForOptionHandler((OptionHandler)value));
                    continue;
                }
                if (value instanceof SelectedTag) {
                    options.add("" + ((SelectedTag)value).getSelectedTag().getReadable());
                    continue;
                }
                if (parameterDescription.commandLineParamIsFlag()) {
                    if (!(value instanceof Boolean)) {
                        throw new IllegalArgumentException("Getter method for a command line flag should return a boolean value");
                    }
                    if (!((Boolean)value).booleanValue()) continue;
                    options.add("-" + parameterDescription.commandLineParamName());
                    continue;
                }
                if (value.toString().length() > 0) {
                    options.add(value.toString());
                    continue;
                }
                options.remove(options.size() - 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return options.toArray(new String[options.size()]);
    }

    protected static String getOptionStringForOptionHandler(OptionHandler handler) {
        String optHandlerClassName = handler.getClass().getCanonicalName();
        String optsVal = Utils.joinOptions(handler.getOptions());
        String totalOptVal = optHandlerClassName + " " + optsVal;
        return totalOptVal;
    }

    public static void setOptionsForHierarchy(String[] options, Object target, Class<?> oldestAncestorClazz) {
        Option.setOptions(options, target, target.getClass());
        Class<?> parent = target.getClass();
        while ((parent = parent.getSuperclass()) != null) {
            Option.setOptions(options, target, parent);
            if (!parent.equals(oldestAncestorClazz)) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setOptions(String[] options, Object target, Class<?> targetClazz) {
        block27: {
            if (options == null || options.length <= 0) break block27;
            try {
                getterArgs = new Object[]{};
                parent = targetClazz.getSuperclass();
                bi = Introspector.getBeanInfo(targetClazz, parent);
                for (PropertyDescriptor p : properties = bi.getPropertyDescriptors()) {
                    block29: {
                        block28: {
                            getter = p.getReadMethod();
                            setter = p.getWriteMethod();
                            if (getter == null || setter == null) continue;
                            parameterDescription = null;
                            parameterDescription = getter.getAnnotation(OptionMetadata.class);
                            if (parameterDescription == null) {
                                parameterDescription = setter.getAnnotation(OptionMetadata.class);
                            }
                            if (parameterDescription == null || parameterDescription.commandLineParamName().length() <= 0) continue;
                            processOpt = false;
                            optionValue = "";
                            valueToSet = null;
                            if (parameterDescription.commandLineParamIsFlag()) {
                                processOpt = true;
                                valueToSet = Utils.getFlag(parameterDescription.commandLineParamName(), options);
                            } else {
                                optionValue = Utils.getOption(parameterDescription.commandLineParamName(), options);
                                processOpt = optionValue.length() > 0;
                            }
                            value = getter.invoke(target, getterArgs);
                            if (value == null || !processOpt) continue;
                            if (!value.getClass().isArray() || ((Object[])value).length < 0) break block28;
                            elementType = getter.getReturnType().getComponentType();
                            optionValues = new ArrayList<String>();
                            optionValues.add(optionValue);
                            while ((optionValue = Utils.getOption(parameterDescription.commandLineParamName(), options)).length() != 0) {
                                optionValues.add(optionValue);
                            }
                            valueToSet = Array.newInstance(elementType, optionValues.size());
                            for (i = 0; i < optionValues.size(); ++i) {
                                elementObject = null;
                                elementObject = elementType.isAssignableFrom(File.class) != false ? new File((String)optionValues.get(i)) : Option.constructOptionHandlerValue((String)optionValues.get(i));
                                Array.set(valueToSet, i, elementObject);
                            }
                            break block29;
                        }
                        if (!(value instanceof SelectedTag)) ** GOTO lbl63
                        legalTags = ((SelectedTag)value).getTags();
                        tagIndex = 0x7FFFFFFF;
                        try {
                            specifiedID = Integer.parseInt(optionValue);
                            for (z = 0; z < legalTags.length; ++z) {
                                if (legalTags[z].getID() != specifiedID) continue;
                                tagIndex = z;
                                break;
                            }
                        }
                        catch (NumberFormatException e) {
                            for (z = 0; z < legalTags.length; ++z) {
                                if (!legalTags[z].getReadable().equals(optionValue.trim())) continue;
                                tagIndex = z;
                                break;
                            }
                        }
                        if (tagIndex != 0x7FFFFFFF) {
                            valueToSet = new SelectedTag(tagIndex, legalTags);
                        } else {
                            throw new Exception("Unable to set option: '" + parameterDescription.commandLineParamName() + "'. This option takes a SelectedTag argument, and " + "the supplied value of '" + optionValue + "' " + "does not match any of the legal IDs or strings " + "for it.");
lbl63:
                            // 1 sources

                            if (value instanceof OptionHandler) {
                                valueToSet = Option.constructOptionHandlerValue(optionValue);
                            } else if (value instanceof Number) {
                                try {
                                    if (value instanceof Integer) {
                                        valueToSet = new Integer(optionValue);
                                    }
                                    if (value instanceof Long) {
                                        valueToSet = new Long(optionValue);
                                    }
                                    if (value instanceof Double) {
                                        valueToSet = new Double(optionValue);
                                    }
                                    if (!(value instanceof Float)) ** GOTO lbl87
                                    valueToSet = new Float(optionValue);
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("Option: '" + parameterDescription.commandLineParamName() + "' requires a " + value.getClass().getCanonicalName() + " argument");
                                }
                            } else if (value instanceof String) {
                                valueToSet = optionValue;
                            } else if (value instanceof File) {
                                valueToSet = new File(optionValue);
                            }
                        }
                    }
                    if (valueToSet == null) continue;
                    Option.setOption(setter, target, valueToSet);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected static Object constructOptionHandlerValue(String optionValue) throws Exception {
        String[] optHandlerSpec = Utils.splitOptions(optionValue);
        if (optHandlerSpec.length == 0) {
            throw new Exception("Invalid option handler specification string '" + optionValue);
        }
        String optionHandler = optHandlerSpec[0];
        optHandlerSpec[0] = "";
        Object handler = Utils.forName(null, optionHandler, optHandlerSpec);
        return handler;
    }

    protected static void setOption(Method setter, Object target, Object valueToSet) throws InvocationTargetException, IllegalAccessException {
        Object[] setterArgs = new Object[]{valueToSet};
        setter.invoke(target, setterArgs);
    }

    public String description() {
        return this.m_Description;
    }

    public String name() {
        return this.m_Name;
    }

    public int numArguments() {
        return this.m_NumArguments;
    }

    public String synopsis() {
        return this.m_Synopsis;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11775 $");
    }
}

