/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.meta.generators.Mean;
import weka.classifiers.meta.generators.RandomizableGenerator;
import weka.core.Option;
import weka.core.Utils;

public abstract class RandomizableDistributionGenerator
extends RandomizableGenerator
implements Mean {
    private static final long serialVersionUID = 955762136858704289L;
    protected double m_Mean = 0.0;
    protected double m_StandardDeviation = 1.0;

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement(enu.nextElement());
        }
        result.addElement(new Option("\tSets the mean of the generator\n\t(default: 0)", "M", 1, "-M <num>"));
        result.addElement(new Option("\tSets the standard deviation of the generator\n\t(default: 1)", "SD", 1, "-SD <num>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("M", options);
        if (tmpStr.length() != 0) {
            this.setMean(Double.parseDouble(tmpStr));
        } else {
            this.setMean(0.0);
        }
        tmpStr = Utils.getOption("SD", options);
        if (tmpStr.length() != 0) {
            this.setStandardDeviation(Double.parseDouble(tmpStr));
        } else {
            this.setStandardDeviation(1.0);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-M");
        result.add("" + this.m_Mean);
        result.add("-SD");
        result.add("" + this.m_StandardDeviation);
        return result.toArray(new String[result.size()]);
    }

    public double getMean() {
        return this.m_Mean;
    }

    public void setMean(double value) {
        this.m_Mean = value;
    }

    public String meanTipText() {
        return "The mean of the underlying distribution.";
    }

    public double getStandardDeviation() {
        return this.m_StandardDeviation;
    }

    public void setStandardDeviation(double value) {
        this.m_StandardDeviation = value > 0.0 ? value : 0.01;
    }

    public String standardDeviationTipText() {
        return "The standard deviation of the underlying distribution.";
    }
}

