/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.AddModelsPanel;
import weka.gui.ensembleLibraryEditor.tree.CheckBoxNode;
import weka.gui.ensembleLibraryEditor.tree.DefaultNode;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;
import weka.gui.ensembleLibraryEditor.tree.InvalidInputException;
import weka.gui.ensembleLibraryEditor.tree.NumberClassNotFoundException;
import weka.gui.ensembleLibraryEditor.tree.NumberNode;

public class PropertyNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 8179038568780212829L;
    private final AddModelsPanel m_ParentPanel;
    private String m_Name;
    private String m_ToolTipText;
    private PropertyEditor m_PropertyEditor;
    private DefaultTreeModel m_TreeModel;
    private JTree m_Tree;

    public PropertyNode(JTree tree, AddModelsPanel panel, String name, String toolTipText, Object value, PropertyEditor pe) {
        super(value);
        this.m_Tree = tree;
        this.m_TreeModel = (DefaultTreeModel)this.m_Tree.getModel();
        this.m_ParentPanel = panel;
        this.m_Name = name;
        this.m_ToolTipText = toolTipText;
        this.m_PropertyEditor = pe;
        this.addEditorNodes(name, toolTipText);
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    public String getName() {
        return this.m_Name;
    }

    public PropertyEditor getPropertyEditor() {
        return this.m_PropertyEditor;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getUserObject().toString() + "]";
    }

    public void addEditorNodes(String name, String toolTipText) {
        Object value = this.getUserObject();
        if (value instanceof Number) {
            NumberNode minNode = new NumberNode("min: ", (Number)value, 0, false, toolTipText);
            this.m_TreeModel.insertNodeInto(minNode, this, 0);
            Number one = null;
            try {
                one = minNode.getOneValue();
            }
            catch (NumberClassNotFoundException e) {
                e.printStackTrace();
            }
            NumberNode iteratorNode = new NumberNode("iterator: ", one, 2, true, toolTipText);
            this.m_TreeModel.insertNodeInto(iteratorNode, this, 1);
            NumberNode maxNode = new NumberNode("max: ", (Number)value, 0, true, toolTipText);
            this.m_TreeModel.insertNodeInto(maxNode, this, 2);
        } else if (this.m_PropertyEditor instanceof GenericObjectEditor) {
            GenericObjectNode classifierNode = new GenericObjectNode(this.m_ParentPanel, value, (GenericObjectEditor)this.m_PropertyEditor, toolTipText);
            this.m_TreeModel.insertNodeInto(classifierNode, this, 0);
            classifierNode.setTree(this.m_Tree);
            classifierNode.updateTree();
        } else if (this.m_PropertyEditor.getTags() != null) {
            String selected = this.m_PropertyEditor.getAsText();
            String[] tags = this.m_PropertyEditor.getTags();
            if (tags != null) {
                for (int i = 0; i < tags.length; ++i) {
                    CheckBoxNode checkBoxNode = new CheckBoxNode(tags[i], selected.equals(tags[i]), toolTipText);
                    this.m_TreeModel.insertNodeInto(checkBoxNode, this, i);
                }
            }
        } else {
            DefaultNode defaultNode = new DefaultNode(name, toolTipText, value, this.m_PropertyEditor);
            this.m_TreeModel.insertNodeInto(defaultNode, this, 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllValues() {
        Vector values = new Vector();
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.m_TreeModel.getChild(this, 0);
        if (child instanceof GenericObjectNode) {
            return ((GenericObjectNode)child).getValues();
        }
        if (child instanceof DefaultNode) {
            values.add(((DefaultNode)child).getUserObject());
            return values;
        }
        if (child instanceof CheckBoxNode) {
            int childCount = this.m_TreeModel.getChildCount(this);
            int i = 0;
            while (i < childCount) {
                CheckBoxNode currentChild = (CheckBoxNode)this.m_TreeModel.getChild(this, i);
                if (currentChild.getSelected()) {
                    values.add(currentChild.getUserObject());
                }
                ++i;
            }
            return values;
        }
        if (!(child instanceof NumberNode)) return values;
        NumberNode minChild = (NumberNode)this.m_TreeModel.getChild(this, 0);
        NumberNode iteratorChild = (NumberNode)this.m_TreeModel.getChild(this, 1);
        NumberNode maxChild = (NumberNode)this.m_TreeModel.getChild(this, 2);
        boolean ignoreIterator = false;
        try {
            if (iteratorChild.getSelected()) {
                if (maxChild.lessThan(maxChild.getValue(), minChild.getValue())) {
                    ignoreIterator = true;
                    throw new InvalidInputException("Invalid numeric input for node " + this.getName() + ": min > max. ");
                }
                if (iteratorChild.getIteratorType() == 2 && (iteratorChild.lessThan(iteratorChild.getValue(), iteratorChild.getZeroValue()) || iteratorChild.equals(iteratorChild.getValue(), iteratorChild.getZeroValue()))) {
                    ignoreIterator = true;
                    throw new InvalidInputException("Invalid numeric input for node " + this.getName() + ": += iterator <= 0. ");
                }
                if (iteratorChild.getIteratorType() == 1 && (iteratorChild.lessThan(iteratorChild.getValue(), iteratorChild.getOneValue()) || iteratorChild.equals(iteratorChild.getValue(), iteratorChild.getOneValue()))) {
                    ignoreIterator = true;
                    throw new InvalidInputException("Invalid numeric input for node " + this.getName() + ": *= iterator <= 1. ");
                }
            }
        }
        catch (InvalidInputException e) {
            JRootPane parent = this.m_ParentPanel.getRootPane();
            JOptionPane.showMessageDialog(parent, "Invalid Input: " + e.getMessage(), "Input error", 0);
            e.printStackTrace();
        }
        catch (NumberClassNotFoundException e) {
            e.printStackTrace();
        }
        if (!iteratorChild.getSelected() || ignoreIterator) {
            values.add(minChild.getUserObject());
            if (!maxChild.getSelected()) return values;
            if (maxChild.getValue().equals(minChild.getValue())) return values;
            values.add(maxChild.getUserObject());
            return values;
        }
        Number current = minChild.getValue();
        try {
            values.add(minChild.getValue());
            do {
                Number newNumber = null;
                if (iteratorChild.getIteratorType() == 2) {
                    newNumber = iteratorChild.addNumbers(iteratorChild.getValue(), current);
                } else if (iteratorChild.getIteratorType() == 1) {
                    newNumber = iteratorChild.multiplyNumbers(iteratorChild.getValue(), current);
                }
                current = newNumber;
                if (!iteratorChild.lessThan(current, maxChild.getValue()) || iteratorChild.equals(current, maxChild.getValue())) continue;
                values.add(newNumber);
            } while (iteratorChild.lessThan(current, maxChild.getValue()) && !iteratorChild.equals(current, maxChild.getValue()));
            if (!maxChild.getSelected()) return values;
            if (maxChild.getValue().equals(minChild.getValue())) return values;
            values.add(maxChild.getUserObject());
            return values;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public boolean canSelect(NumberNode node) {
        boolean permission = true;
        NumberNode iteratorChild = (NumberNode)this.m_TreeModel.getChild(this, 1);
        NumberNode maxChild = (NumberNode)this.m_TreeModel.getChild(this, 2);
        if (node == iteratorChild && !maxChild.getSelected()) {
            permission = false;
        }
        return permission;
    }

    public boolean canDeselect(DefaultMutableTreeNode node) {
        boolean permission = true;
        if (node instanceof NumberNode) {
            NumberNode iteratorChild = (NumberNode)this.m_TreeModel.getChild(this, 1);
            NumberNode maxChild = (NumberNode)this.m_TreeModel.getChild(this, 2);
            if (node == maxChild && iteratorChild.getSelected()) {
                permission = false;
            }
        } else if (node instanceof CheckBoxNode) {
            int totalSelected = 0;
            int childCount = this.m_TreeModel.getChildCount(this);
            for (int i = 0; i < childCount; ++i) {
                CheckBoxNode currentChild = (CheckBoxNode)this.m_TreeModel.getChild(this, i);
                if (!currentChild.getSelected()) continue;
                ++totalSelected;
            }
            if (totalSelected == 1) {
                permission = false;
            }
        }
        return permission;
    }
}

