/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.EnsembleLibrary;
import weka.classifiers.EnsembleLibraryModel;
import weka.gui.ensembleLibraryEditor.ModelList;

public class ListModelsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1986253077944432252L;
    private EnsembleLibrary m_Library;
    private JButton m_RemoveSelectedButton;
    private JButton m_OpenModelFileButton;
    private JButton m_SaveModelFileButton;
    private ModelList m_ModelList;
    private JFileChooser m_modelListChooser = new JFileChooser(new File(System.getProperty("user.dir")));

    public ListModelsPanel(EnsembleLibrary library) {
        this.m_Library = library;
        this.createListModelsPanel();
    }

    public void setLibrary(EnsembleLibrary library) {
        this.m_Library = library;
    }

    private void createListModelsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        JPanel modelListPanel = new JPanel();
        modelListPanel.setBorder(BorderFactory.createTitledBorder("Currently Chosen Library Models"));
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = 8178827388328307805L;

            public void actionPerformed(ActionEvent evt) {
                Object[] currentModels = ListModelsPanel.this.m_ModelList.getSelectedValues();
                for (int i = 0; i < currentModels.length; ++i) {
                    ListModelsPanel.this.removeModel((EnsembleLibraryModel)currentModels[i]);
                }
                int[] selected = new int[]{ListModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                ListModelsPanel.this.m_ModelList.setSelectedIndices(selected);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setVisibleRowCount(-1);
        this.m_ModelList.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.m_ModelList);
        listScroller.setPreferredSize(new Dimension(150, 50));
        modelListPanel.setLayout(new BorderLayout());
        modelListPanel.add((Component)listScroller, "Center");
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        this.add((Component)modelListPanel, gbc);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.addActionListener(this);
        this.m_RemoveSelectedButton.setToolTipText("Remove all currently selected models from the above list");
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gbc);
        this.m_modelListChooser.setAcceptAllFileFilterUsed(false);
        XMLModelFileFilter xmlFilter = new XMLModelFileFilter();
        this.m_modelListChooser.addChoosableFileFilter(xmlFilter);
        this.m_modelListChooser.addChoosableFileFilter(new FlatModelFileFilter());
        this.m_modelListChooser.setFileFilter(xmlFilter);
        this.m_modelListChooser.setFileSelectionMode(0);
        this.m_OpenModelFileButton = new JButton("Open...");
        this.m_OpenModelFileButton.addActionListener(this);
        this.m_OpenModelFileButton.setToolTipText("Import a model list file from the file system");
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.m_OpenModelFileButton, gbc);
        this.m_SaveModelFileButton = new JButton("Save...");
        this.m_SaveModelFileButton.addActionListener(this);
        this.m_SaveModelFileButton.setToolTipText("Save the current list of models to a file");
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.m_SaveModelFileButton, gbc);
    }

    public EnsembleLibrary getLibrary() {
        return this.m_Library;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_OpenModelFileButton) {
            int returnVal = this.m_modelListChooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.clearAll();
                File selectedFile = this.m_modelListChooser.getSelectedFile();
                if (this.m_modelListChooser.getFileFilter() instanceof FlatModelFileFilter) {
                    if (!selectedFile.getName().endsWith(".mlf")) {
                        selectedFile = new File(selectedFile.getPath() + ".mlf");
                    }
                } else if (!selectedFile.getName().endsWith(".model.xml")) {
                    selectedFile = new File(selectedFile.getPath() + ".model.xml");
                }
                EnsembleLibrary.loadLibrary(selectedFile, this, this.m_Library);
                ModelList.SortedListModel dataModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
                TreeSet models = this.m_Library.getModels();
                Iterator it = models.iterator();
                while (it.hasNext()) {
                    this.addModel((EnsembleLibraryModel)it.next());
                }
            }
        } else if (e.getSource() == this.m_SaveModelFileButton) {
            int returnVal = this.m_modelListChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File selectedFile = this.m_modelListChooser.getSelectedFile();
                if (this.m_modelListChooser.getFileFilter() instanceof FlatModelFileFilter) {
                    if (!selectedFile.getName().endsWith(".mlf")) {
                        selectedFile = new File(selectedFile.getPath() + ".mlf");
                    }
                } else if (!selectedFile.getName().endsWith(".model.xml")) {
                    selectedFile = new File(selectedFile.getPath() + ".model.xml");
                }
                EnsembleLibrary.saveLibrary(selectedFile, this.m_Library, this);
            }
        } else if (e.getSource() == this.m_RemoveSelectedButton) {
            Object[] currentModels = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < currentModels.length; ++i) {
                this.removeModel((EnsembleLibraryModel)currentModels[i]);
            }
            if (this.m_ModelList.getSelectedIndices().length > 0) {
                int[] selected = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(selected);
            }
        }
    }

    public void clearAll() {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).clear();
        this.m_Library.clearModels();
    }

    public void addModel(EnsembleLibraryModel model) {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).add(model);
        this.m_Library.addModel(model);
    }

    public void removeModel(EnsembleLibraryModel model) {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).removeElement(model);
        this.m_Library.removeModel(model);
    }

    class FlatModelFileFilter
    extends FileFilter {
        FlatModelFileFilter() {
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".mlf") || file.isDirectory();
        }

        public String getDescription() {
            return "Model List Files (*.mlf)";
        }
    }

    class XMLModelFileFilter
    extends FileFilter {
        XMLModelFileFilter() {
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".model.xml") || file.isDirectory();
        }

        public String getDescription() {
            return "XML Library Files (*.model.xml)";
        }
    }
}

