/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class CachedKernel
extends Kernel {
    private static final long serialVersionUID = 702810182699015136L;
    protected int m_kernelEvals;
    protected int m_cacheHits;
    protected int m_cacheSize = 250007;
    protected double[] m_storage;
    protected long[] m_keys;
    protected double[][] m_kernelMatrix;
    protected int m_numInsts;
    protected int m_cacheSlots = 4;

    public CachedKernel() {
    }

    protected CachedKernel(Instances instances, int n) throws Exception {
        this.setCacheSize(n);
        this.buildKernel(instances);
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe size of the cache (a prime number), 0 for full cache and \n\t-1 to turn it off.\n\t(default: 250007)", "C", 1, "-C <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setCacheSize(Integer.parseInt(string));
        } else {
            this.setCacheSize(250007);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add("" + this.getCacheSize());
        return vector.toArray(new String[vector.size()]);
    }

    protected abstract double evaluate(int var1, int var2, Instance var3) throws Exception;

    public double eval(int n, int n2, Instance instance) throws Exception {
        double d = 0.0;
        long l = -1L;
        int n3 = -1;
        if (n >= 0 && this.m_cacheSize != -1) {
            long l2;
            if (this.m_cacheSize == 0) {
                if (this.m_kernelMatrix == null) {
                    this.m_kernelMatrix = new double[this.m_data.numInstances()][];
                    for (int i = 0; i < this.m_data.numInstances(); ++i) {
                        this.m_kernelMatrix[i] = new double[i + 1];
                        for (int j = 0; j <= i; ++j) {
                            ++this.m_kernelEvals;
                            this.m_kernelMatrix[i][j] = this.evaluate(i, j, this.m_data.instance(i));
                        }
                    }
                }
                ++this.m_cacheHits;
                d = n > n2 ? this.m_kernelMatrix[n][n2] : this.m_kernelMatrix[n2][n];
                return d;
            }
            l = n > n2 ? (long)n + (long)n2 * (long)this.m_numInsts : (long)n2 + (long)n * (long)this.m_numInsts;
            int n4 = n3 = (int)(l % (long)this.m_cacheSize) * this.m_cacheSlots;
            for (int i = 0; i < this.m_cacheSlots && (l2 = this.m_keys[n4]) != 0L; ++i) {
                if (l2 == l + 1L) {
                    ++this.m_cacheHits;
                    if (i > 0) {
                        double d2 = this.m_storage[n4];
                        this.m_storage[n4] = this.m_storage[n3];
                        this.m_keys[n4] = this.m_keys[n3];
                        this.m_storage[n3] = d2;
                        this.m_keys[n3] = l2;
                        return d2;
                    }
                    return this.m_storage[n4];
                }
                ++n4;
            }
        }
        d = this.evaluate(n, n2, instance);
        ++this.m_kernelEvals;
        if (l != -1L && this.m_cacheSize != -1) {
            System.arraycopy(this.m_keys, n3, this.m_keys, n3 + 1, this.m_cacheSlots - 1);
            System.arraycopy(this.m_storage, n3, this.m_storage, n3 + 1, this.m_cacheSlots - 1);
            this.m_storage[n3] = d;
            this.m_keys[n3] = l + 1L;
        }
        return d;
    }

    public int numEvals() {
        return this.m_kernelEvals;
    }

    public int numCacheHits() {
        return this.m_cacheHits;
    }

    public void clean() {
        this.m_storage = null;
        this.m_keys = null;
        this.m_kernelMatrix = null;
    }

    protected final double dotProd(Instance instance, Instance instance2) throws Exception {
        double d = 0.0;
        int n = instance.numValues();
        int n2 = instance2.numValues();
        int n3 = this.m_data.classIndex();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n && n5 < n2) {
            int n6;
            int n7 = instance.index(n4);
            if (n7 == (n6 = instance2.index(n5))) {
                if (n7 != n3) {
                    d += instance.valueSparse(n4) * instance2.valueSparse(n5);
                }
                ++n4;
                ++n5;
                continue;
            }
            if (n7 > n6) {
                ++n5;
                continue;
            }
            ++n4;
        }
        return d;
    }

    public void setCacheSize(int n) {
        if (n >= -1) {
            this.m_cacheSize = n;
            this.clean();
        } else {
            System.out.println("Cache size cannot be smaller than -1 (provided: " + n + ")!");
        }
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public String cacheSizeTipText() {
        return "The size of the cache (a prime number), 0 for full cache and -1 to turn it off.";
    }

    protected void initVars(Instances instances) {
        super.initVars(instances);
        this.m_kernelEvals = 0;
        this.m_cacheHits = 0;
        this.m_numInsts = this.m_data.numInstances();
        if (this.getCacheSize() > 0) {
            this.m_storage = new double[this.m_cacheSize * this.m_cacheSlots];
            this.m_keys = new long[this.m_cacheSize * this.m_cacheSlots];
        } else {
            this.m_storage = null;
            this.m_keys = null;
            this.m_kernelMatrix = null;
        }
    }

    public void buildKernel(Instances instances) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(instances);
        }
        this.initVars(instances);
    }
}

