/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class ClassOrder
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -2116226838887628411L;
    private long m_Seed = 1L;
    private Random m_Random = null;
    private int[] m_Converter = null;
    private Attribute m_ClassAttribute = null;
    private int m_ClassOrder = 0;
    public static final int FREQ_ASCEND = 0;
    public static final int FREQ_DESCEND = 1;
    public static final int RANDOM = 2;
    private double[] m_ClassCounts = null;

    public String globalInfo() {
        return "Changes the order of the classes so that the class values are no longer of in the order specified in the header. The values will be in the order specified by the user -- it could be either in ascending/descending order by the class frequency or in random order. Note that this filter currently does not change the header, only the class values of the instances, so there is not much point in using it in conjunction with the FilteredClassifier. The value can also be converted back using 'originalValue(double value)' procedure.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSpecify the seed of randomization\n\tused to randomize the class\n\torder (default: 1)", "R", 1, "-R <seed>"));
        vector.addElement(new Option("\tSpecify the class order to be\n\tsorted, could be 0: ascending\n\t1: descending and 2: random.(default: 0)", "C", 1, "-C <order>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        this.m_Seed = string.length() != 0 ? Long.parseLong(string) : 1L;
        String string2 = Utils.getOption('C', stringArray);
        this.m_ClassOrder = string2.length() != 0 ? Integer.parseInt(string2) : 0;
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        this.m_Random = null;
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.m_Seed;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_ClassOrder;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String seedTipText() {
        return "Specify the seed of randomization of the class order";
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public void setSeed(long l) {
        this.m_Seed = l;
        this.m_Random = null;
    }

    public String classOrderTipText() {
        return "Specify the class order after the filtering";
    }

    public int getClassOrder() {
        return this.m_ClassOrder;
    }

    public void setClassOrder(int n) {
        this.m_ClassOrder = n;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(new Instances(instances, 0));
        this.m_ClassAttribute = instances.classAttribute();
        this.m_Random = new Random(this.m_Seed);
        this.m_Converter = null;
        int n = instances.numClasses();
        this.m_ClassCounts = new double[n];
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Converter != null) {
            Instance instance2 = (Instance)instance.copy();
            if (!instance2.isMissing(this.m_ClassAttribute)) {
                instance2.setClassValue(this.m_Converter[(int)instance2.classValue()]);
            }
            this.push(instance2);
            return true;
        }
        if (!instance.isMissing(this.m_ClassAttribute)) {
            int n = (int)instance.classValue();
            this.m_ClassCounts[n] = this.m_ClassCounts[n] + instance.weight();
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        Instances instances = this.getInputFormat();
        if (instances == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Converter == null) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int[] nArray = new int[this.m_ClassCounts.length];
            for (n5 = 0; n5 < nArray.length; ++n5) {
                nArray[n5] = n5;
            }
            for (n5 = nArray.length - 1; n5 > 0; --n5) {
                n4 = this.m_Random.nextInt(n5 + 1);
                n3 = nArray[n5];
                nArray[n5] = nArray[n4];
                nArray[n4] = n3;
            }
            double[] dArray = new double[this.m_ClassCounts.length];
            for (n4 = 0; n4 < dArray.length; ++n4) {
                dArray[n4] = this.m_ClassCounts[nArray[n4]];
            }
            if (this.m_ClassOrder == 2) {
                this.m_Converter = nArray;
                this.m_ClassCounts = dArray;
            } else {
                int[] nArray2 = Utils.sort(dArray);
                this.m_Converter = new int[nArray2.length];
                if (this.m_ClassOrder == 0) {
                    for (n3 = 0; n3 < nArray2.length; ++n3) {
                        this.m_Converter[n3] = nArray[nArray2[n3]];
                    }
                } else if (this.m_ClassOrder == 1) {
                    for (n3 = 0; n3 < nArray2.length; ++n3) {
                        this.m_Converter[n3] = nArray[nArray2[nArray2.length - n3 - 1]];
                    }
                } else {
                    throw new IllegalArgumentException("Class order not defined!");
                }
                double[] dArray2 = new double[this.m_ClassCounts.length];
                for (n2 = 0; n2 < this.m_Converter.length; ++n2) {
                    dArray2[n2] = this.m_ClassCounts[this.m_Converter[n2]];
                }
                this.m_ClassCounts = dArray2;
            }
            FastVector fastVector = new FastVector(instances.classAttribute().numValues());
            for (int i = 0; i < instances.numClasses(); ++i) {
                fastVector.addElement(instances.classAttribute().value(this.m_Converter[i]));
            }
            FastVector fastVector2 = new FastVector(instances.numAttributes());
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                if (n2 == instances.classIndex()) {
                    fastVector2.addElement(new Attribute(instances.classAttribute().name(), fastVector, instances.classAttribute().getMetadata()));
                    continue;
                }
                fastVector2.addElement(instances.attribute(n2));
            }
            Instances instances2 = new Instances(instances.relationName(), fastVector2, 0);
            instances2.setClassIndex(instances.classIndex());
            this.setOutputFormat(instances2);
            int[] nArray3 = new int[this.m_Converter.length];
            for (n = 0; n < nArray3.length; ++n) {
                nArray3[this.m_Converter[n]] = n;
            }
            this.m_Converter = nArray3;
            for (n = 0; n < instances.numInstances(); ++n) {
                Instance instance = instances.instance(n);
                if (!instance.isMissing(instance.classIndex())) {
                    instance.setClassValue(this.m_Converter[(int)instance.classValue()]);
                }
                this.push(instance);
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public double[] getClassCounts() {
        if (this.m_ClassAttribute.isNominal()) {
            return this.m_ClassCounts;
        }
        return null;
    }

    public double[] distributionsByOriginalIndex(double[] dArray) {
        double[] dArray2 = new double[this.m_Converter.length];
        for (int i = 0; i < this.m_Converter.length; ++i) {
            dArray2[i] = dArray[this.m_Converter[i]];
        }
        return dArray2;
    }

    public double originalValue(double d) throws Exception {
        if (this.m_Converter == null) {
            throw new IllegalStateException("Coverter table not defined yet!");
        }
        for (int i = 0; i < this.m_Converter.length; ++i) {
            if ((int)d != this.m_Converter[i]) continue;
            return i;
        }
        return -1.0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5541 $");
    }

    public static void main(String[] stringArray) {
        ClassOrder.runFilter(new ClassOrder(), stringArray);
    }
}

