/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Jython
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -6972298704460209252L;
    public static final String CLASS_PYTHONINERPRETER = "org.python.util.PythonInterpreter";
    public static final String CLASS_PYTHONOBJECTINPUTSTREAM = "org.python.util.PythonObjectInputStream";
    protected static boolean m_Present = false;
    protected Object m_Interpreter = Jython.newInterpreter();

    public Object getInterpreter() {
        return this.m_Interpreter;
    }

    public Object invoke(String string, Class[] classArray, Object[] objectArray) {
        Object object = null;
        if (this.getInterpreter() != null) {
            object = Jython.invoke(this.getInterpreter(), string, classArray, objectArray);
        }
        return object;
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static Object newInterpreter() {
        Object var0 = null;
        if (Jython.isPresent()) {
            try {
                var0 = Class.forName(CLASS_PYTHONINERPRETER).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                var0 = null;
            }
        }
        return var0;
    }

    public static Object newInstance(File file, Class clazz) {
        return Jython.newInstance(file, clazz, new File[0]);
    }

    public static Object newInstance(File file, Class clazz, File[] fileArray) {
        String string;
        Object object = null;
        if (!Jython.isPresent()) {
            return object;
        }
        Object object2 = Jython.newInterpreter();
        if (object2 == null) {
            return object;
        }
        if (fileArray.length > 0) {
            int n;
            Jython.invoke(object2, "exec", new Class[]{String.class}, new Object[]{"import sys"});
            string = "syspath";
            Jython.invoke(object2, "exec", new Class[]{String.class}, new Object[]{string + " = sys.path"});
            HashSet<String> hashSet = new HashSet<String>();
            try {
                String[] stringArray = (String[])Jython.invoke(object2, "get", new Class[]{String.class, Class.class}, new Object[]{string, String[].class});
                for (n = 0; n < stringArray.length; ++n) {
                    hashSet.add(stringArray[n]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (n = 0; n < fileArray.length; ++n) {
                if (hashSet.contains(fileArray[n].getAbsolutePath())) continue;
                Jython.invoke(object2, "exec", new Class[]{String.class}, new Object[]{"sys.path.append('" + fileArray[n].getAbsolutePath() + "')"});
            }
        }
        String string2 = file.getAbsolutePath();
        Jython.invoke(object2, "execfile", new Class[]{String.class}, new Object[]{string2});
        String string3 = string2.substring(string2.lastIndexOf("/") + 1);
        string3 = string3.substring(0, string3.indexOf("."));
        string = string3.toLowerCase();
        String string4 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        String string5 = "=" + string4 + "()";
        Jython.invoke(object2, "exec", new Class[]{String.class}, new Object[]{string + string5});
        try {
            object = Jython.invoke(object2, "get", new Class[]{String.class, Class.class}, new Object[]{string, clazz});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public static Object invoke(Object object, String string, Class[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    public static Object deserialize(InputStream inputStream) {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(CLASS_PYTHONOBJECTINPUTSTREAM);
            Class[] classArray = new Class[]{InputStream.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{inputStream};
            Object obj = constructor.newInstance(objectArray);
            object = Jython.invoke(obj, "readObject", new Class[0], new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Jython present: " + Jython.isPresent());
        } else {
            Jython jython = new Jython();
            if (jython.getInterpreter() == null) {
                System.err.println("Cannot instantiate Python Interpreter!");
            } else {
                jython.invoke("execfile", new Class[]{String.class}, new Object[]{stringArray[0]});
            }
        }
    }

    static {
        try {
            Class.forName(CLASS_PYTHONINERPRETER);
            m_Present = true;
        }
        catch (Exception exception) {
            m_Present = false;
        }
    }
}

